/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "wcommon.h"


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:コマンドラインの解析
    lpszCmdLine,コマンドライン文字列
            RET,引数へのポインタ,NULL:エラー                                */
LPWSTR * WINAPI
MakeArgumentW (LPCWSTR lpszCmdLine)
{
  LPWSTR *ppszArgv = NULL;

  if (lpszCmdLine)
    {
      int nArgc = 1, nLength = 0;
      LPCWSTR p;
      LPWSTR q;

      p = lpszCmdLine;
      while (*p != '\0')
        if (*p != ' ')
          {
            if (*p == '\"')
              while (*p != '\0')
                if (*p == '\"')
                  {
                    p++;
                    if (*p == ' ')
                      break;
                  }
                else if (*p == '\\' && *(p + 1) == '\"')
                  {
                    nLength++;
                    p += 2;
                  }
                else
                  {
                    nLength++;
                    p++;
                  }
            else
              while (*p != '\0' && *p != ' ')
                if (*p == '\"')
                  {
                    p++;
                  }
                else if (*p == '\\' && *(p + 1) == '\"')
                  {
                    nLength++;
                    p += 2;
                  }
                else
                  {
                    nLength++;
                    p++;
                  }
            nLength++;
            nArgc++;
          }
        else
          {
            p++;
          }
      ppszArgv = MemoryAlloc (nArgc * sizeof (LPWSTR)
                                                + nLength * sizeof (WCHAR));
      q = (LPWSTR)(ppszArgv + nArgc);
      nArgc = 0;
      p = lpszCmdLine;
      while (*p != '\0')
        if (*p != ' ')
          {
            ppszArgv[nArgc++] = q;
            if (*p == '\"')
              while (*p != '\0')
                if (*p == '\"')
                  {
                    p++;
                    if (*p == ' ')
                      break;
                  }
                else if (*p == '\\' && *(p + 1) == '\"')
                  {
                    *q++ = '\"';
                    p += 2;
                  }
                else
                  {
                    *q++ = *p++;
                  }
            else
              while (*p != '\0' && *p != ' ')
                if (*p == '\"')
                  {
                    p++;
                  }
                else if (*p == '\\' && *(p + 1) == '\"')
                  {
                    *q++ = '\"';
                    p += 2;
                  }
                else
                  {
                    *q++ = *p++;
                  }
            q++;
          }
        else
          {
            p++;
          }
    }
  return ppszArgv;
}


/*  ja:コマンドラインの解析
    lpszCmdLine,コマンドライン文字列
            RET,引数へのポインタ,NULL:エラー                                */
LPSTR * WINAPI
MakeArgumentA (LPCSTR lpszCmdLine)
{
  LPSTR *ppszArgv = NULL;

  if (lpszCmdLine)
    {
      int nArgc = 1, nLength = 0;
      LPCSTR p;
      LPSTR q;

      p = lpszCmdLine;
      while (*p != '\0')
        if (*p != ' ')
          {
            if (*p == '\"')
              while (*p != '\0')
                if (*p == '\"')
                  {
                    p++;
                    if (*p == ' ')
                      break;
                  }
                else if (*p == '\\' && *(p + 1) == '\"')
                  {
                    nLength++;
                    p += 2;
                  }
                else if (IsDBCSLeadByteEx (CP_ACP, *p))
                  {
                    nLength += 2;
                    p += 2;
                  }
                else
                  {
                    nLength++;
                    p++;
                  }
            else
              while (*p != '\0' && *p != ' ')
                if (*p == '\"')
                  {
                    p++;
                  }
                else if (*p == '\\' && *p == '\"')
                  {
                    nLength++;
                    p += 2;
                  }
                else if (IsDBCSLeadByteEx (CP_ACP, *p))
                  {
                    nLength += 2;
                    p += 2;
                  }
                else
                  {
                    nLength++;
                    p++;
                  }
            nLength++;
            nArgc++;
          }
        else
          {
            p++;
          }
      ppszArgv = MemoryAlloc (nArgc * sizeof (LPSTR)
                                                    + nLength * sizeof (CHAR));
      q = (LPSTR)(ppszArgv + nArgc);
      nArgc = 0;
      p = lpszCmdLine;
      while (*p != '\0')
        if (*p != ' ')
          {
            ppszArgv[nArgc++] = q;
            if (*p == '\"')
              while (*p != '\0')
                if (*p == '\"')
                  {
                    p++;
                    if (*p == ' ')
                      break;
                  }
                else if (*p == '\\' && *(p + 1) == '\"')
                  {
                    *q++ = '\"';
                    p += 2;
                  }
                else if (IsDBCSLeadByteEx (CP_ACP, *p))
                  {
                    *q++ = *p++;
                    *q++ = *p++;
                  }
                else
                  {
                    *q++ = *p++;
                  }
            else
              while (*p != '\0' && *p != ' ')
                if (*p == '\"')
                  {
                    p++;
                  }
                else if (*p == '\\' && *(p + 1) == '\"')
                  {
                    *q++ = '\"';
                    p += 2;
                  }
                else if (IsDBCSLeadByteEx (CP_ACP, *p))
                  {
                    *q++ = *p++;
                    *q++ = *p++;
                  }
                else
                  {
                    *q++ = *p++;
                  }
            q++;
          }
        else
          {
            p++;
          }
    }
  return ppszArgv;
}
