/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WSTRING_H__
#define __WSTRING_H__


#include "wcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:文字が数字であるかどうかを判断する
     ch,文字
    RET,TRUE:数字,FALSE:その他                                              */
BOOL WINAPI
IsCharNumericW (WCHAR ch);


/*  ja:文字が数字であるかどうかを判断する
     ch,文字
    RET,TRUE:数字,FALSE:その他                                              */
BOOL WINAPI
IsCharNumericA (CHAR ch);


/*  ja:文字がコントロールコードであるかどうかを判断する
     ch,文字
    RET,TRUE:コントロールコード,FALSE:その他                                */
BOOL WINAPI
IsCharControlW (WCHAR ch);


/*  ja:文字がコントロールコードであるかどうかを判断する
     ch,文字
    RET,TRUE:コントロールコード,FALSE:その他                                */
BOOL WINAPI
IsCharControlA (CHAR ch);


#ifdef UNICODE
# define IsCharNumeric IsCharNumericW
# define IsCharControl IsCharControlW
#else /* not UNICODE */
# define IsCharNumeric IsCharNumericA
# define IsCharControl IsCharControlA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
#define WCOMMON_STRING_INTEGER_NUMERIC  1
#define WCOMMON_STRING_INTEGER_STRICT   2
#define WCOMMON_STRING_INTEGER_UNSIGNED 4


/*  ja:文字列→数値
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
       ppszEnd,終了文字
         nBase,基数
       dwFlags,フラグ
           RET,数値                                                         */
int WINAPI
StringToIntegerExW (LPCWSTR  lpszString,
                    SSIZE_T  nSize,
                    LPCWSTR *ppszEnd,
                    int      nBase,
                    DWORD    dwFlags);


/*  ja:文字列→数値
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
       ppszEnd,終了文字
         nBase,基数
       dwFlags,フラグ
           RET,数値                                                         */
int WINAPI
StringToIntegerExA (LPCSTR   lpszString,
                    SSIZE_T  nSize,
                    LPCSTR  *ppszEnd,
                    int      nBase,
                    DWORD    dwFlags);


/*  ja:文字列→数値
    lpszString,文字列
       ppszEnd,終了文字
         nBase,基数
           RET,数値                                                         */
int WINAPI
StringToIntegerW (LPCWSTR  lpszString,
                  LPCWSTR *ppszEnd,
                  int      nBase);


/*  ja:文字列→数値
    lpszString,文字列
       ppszEnd,終了文字
         nBase,基数
           RET,数値                                                         */
int WINAPI
StringToIntegerA (LPCSTR   lpszString,
                  LPCSTR  *ppszEnd,
                  int      nBase);


/*  ja:数値→文字列
    nValue,数値
     nBase,基数
     nWide,桁数
       RET,文字列,NULL:エラー                                               */
LPWSTR WINAPI
StringFromIntegerW (int nValue,
                    int nBase,
                    int nWide);


/*  ja:数値→文字列
    nValue,数値
     nBase,基数
     nWide,桁数
       RET,文字列,NULL:エラー                                               */
LPSTR WINAPI
StringFromIntegerA (int nValue,
                    int nBase,
                    int nWide);


/*  ja:数値→文字列
    uValue,数値
     nBase,基数
     nWide,桁数
       RET,文字列,NULL:エラー                                               */
LPWSTR WINAPI
StringFromUnsignedW (unsigned uValue,
                     int      nBase,
                     int      nWide);

/*  ja:数値→文字列
    uValue,数値
     nBase,基数
     nWide,桁数
       RET,文字列,NULL:エラー                                               */
LPSTR WINAPI
StringFromUnsignedA (unsigned uValue,
                     int      nBase,
                     int      nWide);


#ifdef UNICODE
# define StringToIntegerEx StringToIntegerExW
# define StringToInteger StringToIntegerW
# define StringFromInteger StringFromIntegerW
# define StringFromUnsigned StringFromUnsignedW
#else /* not UNICODE */
# define StringToIntegerEx StringToIntegerExA
# define StringToInteger StringToIntegerA
# define StringFromInteger StringFromIntegerA
# define StringFromUnsigned StringFromUnsignedA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:8進数文字列を数値に変換する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
     dwDefault,デフォルト値
           RET,数値                                                         */
DWORD WINAPI
OctExW (LPCWSTR lpszString,
        SSIZE_T nSize,
        DWORD   dwDefault);


/*  ja:8進数文字列を数値に変換する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
     dwDefault,デフォルト値
           RET,数値                                                         */
DWORD WINAPI
OctExA (LPCSTR  lpszString,
        SSIZE_T nSize,
        DWORD   dwDefault);


/*  ja:8進数文字列を数値に変換する
    lpszString,文字列
           RET,数値                                                         */
DWORD WINAPI
OctW (LPCWSTR lpszString);


/*  ja:8進数文字列を数値に変換する
    lpszString,文字列
           RET,数値                                                         */
DWORD WINAPI
OctA (LPCSTR lpszString);


/*  ja:10進数文字列を数値に変換する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
     dwDefault,デフォルト値
           RET,数値                                                         */
DWORD WINAPI
DecExW (LPCWSTR lpszString,
        SSIZE_T nSize,
        DWORD   dwDefault);


/*  ja:10進数文字列を数値に変換する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
     dwDefault,デフォルト値
           RET,数値                                                         */
DWORD WINAPI
DecExA (LPCSTR  lpszString,
        SSIZE_T nSize,
        DWORD   dwDefault);


/*  ja:10進数文字列を数値に変換する
    lpszString,文字列
           RET,数値                                                         */
DWORD WINAPI
DecW (LPCWSTR lpszString);


/*  ja:10進数文字列を数値に変換する
    lpszString,文字列
           RET,数値                                                         */
DWORD WINAPI
DecA (LPCSTR lpszString);


/*  ja:16進数文字列を数値に変換する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
     dwDefault,デフォルト値
           RET,数値                                                         */
DWORD WINAPI
HexExW (LPCWSTR lpszString,
        SSIZE_T nSize,
        DWORD   dwDefault);


/*  ja:16進数文字列を数値に変換する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
     dwDefault,デフォルト値
           RET,数値                                                         */
DWORD WINAPI
HexExA (LPCSTR  lpszString,
        SSIZE_T nSize,
        DWORD   dwDefault);


/*  ja:16進数文字列を数値に変換する
    lpszString,文字列
           RET,数値                                                         */
DWORD WINAPI
HexW (LPCWSTR lpszString);


/*  ja:16進数文字列を数値に変換する
    lpszString,文字列
           RET,数値                                                         */
DWORD WINAPI
HexA (LPCSTR lpszString);


#ifdef UNICODE
# define OctEx OctExW
# define Oct OctW
# define DecEx DecExW
# define Dec DecW
# define HexEx HexExW
# define Hex HexW
#else /* not UNICODE */
# define OctEx OctExA
# define Oct OctA
# define DecEx DecExA
# define Dec DecA
# define HexEx HexExA
# define Hex HexA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:文字列のプレフィックスが一致するときには真
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
    lpszPrefix,プレフィックス
           RET,TRUE:一致,FALSE:不一致                                       */
BOOL WINAPI
StringHasPrefixExW (LPCWSTR lpszString,
                    SSIZE_T nSize,
                    LPCWSTR lpszPrefix);


/*  ja:文字列のプレフィックスが一致するときには真
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
    lpszPrefix,プレフィックス
           RET,TRUE:一致,FALSE:不一致                                       */
BOOL WINAPI
StringHasPrefixExA (LPCSTR  lpszString,
                    SSIZE_T nSize,
                    LPCSTR  lpszPrefix);


/*  ja:文字列のプレフィックスが一致するときには真
    lpszString,文字列
    lpszPrefix,プレフィックス
           RET,TRUE:一致,FALSE:不一致                                       */
BOOL WINAPI
StringHasPrefixW (LPCWSTR lpszString,
                  LPCWSTR lpszPrefix);


/*  ja:文字列のプレフィックスが一致するときには真
    lpszString,文字列
    lpszPrefix,プレフィックス
           RET,TRUE:一致,FALSE:不一致                                       */
BOOL WINAPI
StringHasPrefixA (LPCSTR  lpszString,
                  SSIZE_T nSize,
                  LPCSTR  lpszPrefix);


/*  ja:文字列のプレフィックスが一致するときには真
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
    lpszPrefix,プレフィックス(大文字小文字を区別しない)
           RET,TRUE:一致,FALSE:不一致                                       */
BOOL WINAPI
StringHasPrefixIExW (LPCWSTR lpszString,
                     SSIZE_T nSize,
                     LPCWSTR lpszPrefix);


/*  ja:文字列のプレフィックスが一致するときには真
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
    lpszPrefix,プレフィックス(大文字小文字を区別しない)
           RET,TRUE:一致,FALSE:不一致                                       */
BOOL WINAPI
StringHasPrefixIExA (LPCSTR  lpszString,
                     SSIZE_T nSize,
                     LPCSTR  lpszPrefix);


/*  ja:文字列のプレフィックスが一致するときには真
    lpszString,文字列
    lpszPrefix,プレフィックス(大文字小文字を区別しない)
           RET,TRUE:一致,FALSE:不一致                                       */
BOOL WINAPI
StringHasPrefixIW (LPCWSTR lpszString,
                   LPCWSTR lpszPrefix);


/*  ja:文字列のプレフィックスが一致するときには真
    lpszString,文字列
    lpszPrefix,プレフィックス(大文字小文字を区別しない)
           RET,TRUE:一致,FALSE:不一致                                       */
BOOL WINAPI
StringHasPrefixIA (LPCSTR  lpszString,
                   SSIZE_T nSize,
                  LPCSTR  lpszPrefix);


#ifdef UNICODE
# define StringHasPrefixEx StringHasPrefixExW
# define StringHasPrefix StringHasPrefixW
# define StringHasPrefixIEx StringHasPrefixIExW
# define StringHasPrefixI StringHasPrefixIW
#else /* not UNICODE */
# define StringHasPrefixEx StringHasPrefixExA
# define StringHasPrefix StringHasPrefixA
# define StringHasPrefixIEx StringHasPrefixIExA
# define StringHasPrefixI StringHasPrefixIA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:文字列を書式化する
    ppszString,文字列
    lpszFormat,書式文字列
       arglist,引数
           RET,文字数(終端のNULLを含まない)                                 */
SSIZE_T WINAPI
wvasprintfW (LPWSTR  *ppszString,
             LPCWSTR  lpszFormat,
             va_list  arglist);


/*  ja:文字列を書式化する
    ppszString,文字列
    lpszFormat,書式文字列
       arglist,引数
           RET,文字数(終端のNULLを含まない)                                 */
SSIZE_T WINAPI
wvasprintfA (LPSTR  *ppszString,
             LPCSTR  lpszFormat,
             va_list arglist);


/*  ja:文字列を書式化する
    ppszString,文字列
      lpFormat,書式文字列
           RET,文字数(終端のNULLを含まない)                                 */
SSIZE_T WINAPI
wasprintfW (LPWSTR  *ppszString,
            LPCWSTR  lpszFormat, ...);


/*  ja:文字列を書式化する
    ppszString,文字列
      lpFormat,書式文字列
           RET,文字数(終端のNULLを含まない)                                 */
SSIZE_T WINAPI
wasprintfA (LPSTR  *ppszString,
            LPCSTR  lpszFormat, ...);


/*  ja:文字列を複製する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
           RET,複製したメモリ,NULL:エラー                                   */
LPWSTR WINAPI
StringDuplicateExW (LPCWSTR lpszString,
                    SSIZE_T nSize);


/*  ja:文字列を複製する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
           RET,複製したメモリ,NULL:エラー                                   */
LPSTR WINAPI
StringDuplicateExA (LPCSTR  lpszString,
                    SSIZE_T nSize);


/*  ja:文字列を複製する
    lpszString,文字列
           RET,複製したメモリ,NULL:エラー                                   */
LPWSTR WINAPI
StringDuplicateW (LPCWSTR lpszString);


/*  ja:文字列を複製する
    lpszString,文字列
           RET,複製したメモリ,NULL:エラー                                   */
LPSTR WINAPI
StringDuplicateA (LPCSTR lpszString);


#ifdef UNICODE
# define wvasprintf wvasprintfW
# define wasprintf wasprintfW
# define StringDuplicateEx StringDuplicateExW
# define StringDuplicate StringDuplicateW
#else /* not UNICODE */
# define wvasprintf wvasprintfA
# define wasprintf wasprintfA
# define StringDuplicateEx StringDuplicateExA
# define StringDuplicate StringDuplicateA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:文字列をエスケープする
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
           RET,エスケープされた文字列                                       */
LPWSTR WINAPI
StringEscapeExW (LPCWSTR lpszString,
                 SSIZE_T nSize);


/*  ja:文字列をエスケープする
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
           RET,エスケープされた文字列                                       */
LPSTR WINAPI
StringEscapeExA (LPCSTR  lpszString,
                 SSIZE_T nSize);


/*  ja:文字列をエスケープする
    lpszString,文字列
           RET,エスケープされた文字列                                       */
LPWSTR WINAPI
StringEscapeW (LPCWSTR lpszString);


/*  ja:文字列をエスケープする
    lpszString,文字列
           RET,エスケープされた文字列                                       */
LPSTR WINAPI
StringEscapeA (LPCSTR lpszString);


/*  ja:文字列をエスケープしない
    lpszString,エスケープされた文字列
         nSize,文字数(負:NULL終端文字列)
           RET,文字列                                                       */
LPWSTR WINAPI
StringUnescapeExW (LPCWSTR lpszString,
                   SSIZE_T nSize);


/*  ja:文字列をエスケープしない
    lpszString,エスケープされた文字列
         nSize,文字数(負:NULL終端文字列)
           RET,文字列                                                       */
LPSTR WINAPI
StringUnescapeExA (LPCSTR  lpszString,
                   SSIZE_T nSize);


/*  ja:文字列をエスケープしない
    lpszString,エスケープされた文字列
           RET,文字列                                                       */
LPWSTR WINAPI
StringUnescapeW (LPCWSTR lpszString);


/*  ja:文字列をエスケープしない
    lpszString,エスケープされた文字列
           RET,文字列                                                       */
LPSTR WINAPI
StringUnescapeA (LPCSTR lpszString);


/*  ja:文字列を正規化する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
           RET,正規化された文字列                                           */
LPWSTR WINAPI
StringCanonicalizeExW (LPCWSTR lpszString,
                       SSIZE_T nSize);


/*  ja:文字列を正規化する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
           RET,正規化された文字列                                           */
LPSTR WINAPI
StringCanonicalizeExA (LPCSTR  lpszString,
                       SSIZE_T nSize);


/*  ja:文字列を正規化する
    lpszString,文字列
           RET,正規化された文字列                                           */
LPWSTR WINAPI
StringCanonicalizeW (LPCWSTR lpszString);


/*  ja:文字列を正規化する
    lpszString,文字列
           RET,正規化された文字列                                           */
LPSTR WINAPI
StringCanonicalizeA (LPCSTR lpszString);


#ifdef UNICODE
# define StringEscapeEx StringEscapeExW
# define StringEscape StringEscapeW
# define StringUnescapeEx StringUnescapeExW
# define StringUnescape StringUnescapeW
# define StringCanonicalizeEx StringCanonicalizeExW
# define StringCanonicalize StringCanonicalizeW
#else /* not UNICODE */
# define StringEscapeEx StringEscapeExA
# define StringEscape StringEscapeA
# define StringUnescapeEx StringUnescapeExA
# define StringUnescape StringUnescapeA
# define StringCanonicalizeEx StringCanonicalizeExA
# define StringCanonicalize StringCanonicalizeA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WSTRING_H__ */
