/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.Cardinality;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.MappingList;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;

public class Event2EventRelationship
extends AbstractRelationship {
    private MappingList table;
    private boolean connected = false;
    private RelatedRelationship mappingListConnection;
    private ReusedIdentifier sourceMappingListReuseIdentifier;
    private ReusedIdentifier targetMappingListReuseIdentifier;
    private ReusedIdentifier targetReuseIdentifier;

    public Event2EventRelationship(AbstractEntityModel source, AbstractEntityModel target) {
        this.setSource(source);
        this.setTarget(target);
        this.setCenterMark(true);
    }

    @Override
    public void setSourceCardinality(Cardinality sourceCardinality) {
        Cardinality oldValue = this.getSourceCardinality();
        super.setSourceCardinality(sourceCardinality);
        if (sourceCardinality.equals((Object)Cardinality.MANY)) {
            this.setCenterMark(true);
        } else {
            this.setCenterMark(false);
        }
        if (this.connected && !oldValue.equals((Object)sourceCardinality)) {
            this.createRelationship();
        }
    }

    @Override
    public void connect() {
        super.connect();
        this.connected = true;
        this.createRelationship();
    }

    private void createRelationship() {
        if (this.getSourceCardinality().equals((Object)Cardinality.MANY)) {
            this.removeTargetRelationship();
            this.createMappingList();
        } else {
            this.removeMappingList();
            this.createTargetRelationship();
        }
    }

    @Override
    public void disconnect() {
        if (this.getSourceCardinality().equals((Object)Cardinality.MANY)) {
            this.removeMappingList();
        } else {
            this.removeTargetRelationship();
        }
        super.disconnect();
        this.connected = false;
    }

    private void createTargetRelationship() {
        this.setCenterMark(false);
        if (this.targetReuseIdentifier == null) {
            this.getTarget().addReusedIdentifier(this.getSource());
        } else {
            this.getTarget().addReusedIdentifier(this.getSource(), this.targetReuseIdentifier);
            this.targetReuseIdentifier = null;
        }
    }

    private void removeTargetRelationship() {
        this.targetReuseIdentifier = this.getTarget().removeReusedIdentifier(this.getSource());
    }

    private void createMappingList() {
        if (this.table == null) {
            this.table = new MappingList();
        }
        this.setCenterMark(true);
        AbstractEntityModel sourceEntity = this.getSource();
        AbstractEntityModel targetEntity = this.getTarget();
        this.table.setConstraint(sourceEntity.getConstraint().getTranslated(100, 100));
        Diagram diagram = sourceEntity.getDiagram();
        diagram.addChild(this.table);
        this.table.setName(String.valueOf(sourceEntity.getName()) + "." + targetEntity.getName() + "." + "\u5bfe\u5fdc\u8868");
        if (this.sourceMappingListReuseIdentifier == null) {
            this.table.addReusedIdentifier(sourceEntity);
        } else {
            this.table.addReusedIdentifier(sourceEntity, this.sourceMappingListReuseIdentifier);
            this.sourceMappingListReuseIdentifier = null;
        }
        if (this.targetMappingListReuseIdentifier == null) {
            this.table.addReusedIdentifier(targetEntity);
        } else {
            this.table.addReusedIdentifier(targetEntity, this.targetMappingListReuseIdentifier);
            this.targetMappingListReuseIdentifier = null;
        }
        this.mappingListConnection = new RelatedRelationship(this, this.table);
        this.mappingListConnection.connect();
    }

    private void removeMappingList() {
        if (this.mappingListConnection != null) {
            this.setCenterMark(false);
            this.mappingListConnection.disconnect();
        }
        if (this.table != null) {
            AbstractEntityModel sourceEntity = this.getSource();
            this.sourceMappingListReuseIdentifier = this.table.removeReusedIdentifier(sourceEntity);
            this.targetMappingListReuseIdentifier = this.table.removeReusedIdentifier(this.getTarget());
            sourceEntity.getDiagram().removeChild(this.table);
        }
    }

    @Override
    public boolean isDeletable() {
        if (this.getSourceCardinality().equals((Object)Cardinality.MANY)) {
            return this.table.isDeletable();
        }
        return true;
    }

    @Override
    public void identifierChanged() {
        if (this.getSourceCardinality().equals((Object)Cardinality.MANY)) {
            this.table.fireIdentifierChanged(this);
        } else {
            this.getTarget().fireIdentifierChanged(this);
        }
    }
}

