/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.wizard;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import jp.sourceforge.tmdmaker.XStreamSerializer;
import jp.sourceforge.tmdmaker.model.Diagram;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewDiagramWizard
extends Wizard
implements INewWizard {
    private static Logger logger = LoggerFactory.getLogger(NewDiagramWizard.class);
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewDiagramCreationPage page;

    public NewDiagramWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("\u65b0\u898f\u4f5c\u6210");
    }

    public boolean performFinish() {
        IFile file = this.page.createNewFile();
        if (file == null) {
            return false;
        }
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        }
        catch (PartInitException e) {
            logger.error("open error.", (Throwable)e);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.page = new NewDiagramCreationPage("new TMD", this.selection);
        this.addPage((IWizardPage)this.page);
        super.addPages();
    }

    private static class NewDiagramCreationPage
    extends WizardNewFileCreationPage {
        public NewDiagramCreationPage(String string, IStructuredSelection selection) {
            super(string, selection);
            this.setFileExtension("tmd");
            this.setFileName("diagram.tmd");
        }

        protected InputStream getInitialContents() {
            Diagram diagram = new Diagram();
            try {
                return XStreamSerializer.serializeStream(diagram, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

