/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.math.BigDecimal;
import org.eclipse.draw2d.geometry.PrecisionPoint;

public class Vector {
    public double x;
    public double y;
    private static final Vector NULL = new Vector(0.0, 0.0);
    private static final int ROUNDING = 6;
    private static final int SCALE = 16;

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector(PrecisionPoint p) {
        this.x = p.preciseX;
        this.y = p.preciseY;
    }

    public Vector(PrecisionPoint start, PrecisionPoint end) {
        this.x = end.preciseX - start.preciseX;
        this.y = end.preciseY - start.preciseY;
    }

    public Vector(Vector start, Vector end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public double getDissimilarity(Vector other) {
        return Vector.preciseAbs(this.getCrossProduct(other));
    }

    public boolean isParallelTo(Vector other) {
        return this.getDissimilarity(other) == 0.0;
    }

    public double getDotProduct(Vector other) {
        return Vector.preciseAdd(Vector.preciseMultiply(this.x, other.x), Vector.preciseMultiply(this.y, other.y));
    }

    public double getCrossProduct(Vector other) {
        return Vector.preciseSubtract(Vector.preciseMultiply(this.x, other.y), Vector.preciseMultiply(this.y, other.x));
    }

    public Vector getAdded(Vector other) {
        return new Vector(Vector.preciseAdd(this.x, other.x), Vector.preciseAdd(this.y, other.y));
    }

    public Vector getSubtracted(Vector other) {
        return new Vector(Vector.preciseSubtract(this.x, other.x), Vector.preciseSubtract(this.y, other.y));
    }

    public double getAngle(Vector other) {
        double cosAlpha = Vector.preciseDivide(this.getDotProduct(other), Vector.preciseMultiply(this.getLength(), other.getLength()));
        return Math.toDegrees(Math.acos(cosAlpha));
    }

    public Vector getAveraged(Vector other) {
        return new Vector(Vector.preciseDivide(Vector.preciseAdd(this.x, other.x), 2.0), Vector.preciseDivide(Vector.preciseAdd(this.y, other.y), 2.0));
    }

    public Vector getMultiplied(double factor) {
        return new Vector(Vector.preciseMultiply(this.x, factor), Vector.preciseMultiply(this.y, factor));
    }

    public Vector getDivided(double factor) {
        return new Vector(Vector.preciseDivide(this.x, factor), Vector.preciseDivide(this.y, factor));
    }

    public Vector getOrthogonalComplement() {
        return new Vector(Vector.preciseNegate(this.y), this.x);
    }

    public double getLength() {
        return Math.sqrt(this.getDotProduct(this));
    }

    public double getSimilarity(Vector other) {
        return Vector.preciseAbs(this.getDotProduct(other));
    }

    public boolean isOrthogonalTo(Vector other) {
        return this.getSimilarity(other) == 0.0;
    }

    public boolean isHorizontal() {
        return this.x != 0.0;
    }

    public boolean isVertical() {
        return this.y != 0.0;
    }

    public boolean isNull() {
        return this.equals(NULL);
    }

    public PrecisionPoint toPoint() {
        return new PrecisionPoint(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Vector) {
            Vector r = (Vector)obj;
            return this.x == r.x && this.y == r.y;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.x + (int)this.y;
    }

    private static final double preciseAdd(double d1, double d2) {
        return Vector.doubleToBigDecimal(d1).add(Vector.doubleToBigDecimal(d2)).setScale(16, 6).doubleValue();
    }

    private static final double preciseSubtract(double d1, double d2) {
        return Vector.doubleToBigDecimal(d1).subtract(Vector.doubleToBigDecimal(d2)).setScale(16, 6).doubleValue();
    }

    private static final double preciseMultiply(double d1, double d2) {
        return Vector.doubleToBigDecimal(d1).multiply(Vector.doubleToBigDecimal(d2)).setScale(16, 6).doubleValue();
    }

    private static final double preciseDivide(double d1, double d2) {
        return Vector.doubleToBigDecimal(d1).divide(Vector.doubleToBigDecimal(d2), 16, 6).doubleValue();
    }

    private static final double preciseNegate(double d) {
        return Vector.doubleToBigDecimal(d).negate().setScale(16, 6).doubleValue();
    }

    private static final double preciseAbs(double d) {
        return Vector.doubleToBigDecimal(d).abs().setScale(16, 6).doubleValue();
    }

    private static final BigDecimal doubleToBigDecimal(double d) {
        return new BigDecimal(Double.toString(d));
    }
}

