/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.dialog.TableEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.ReconnectableNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.MappingList;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.model.command.TableDeleteCommand;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class MappingListEditPart
extends AbstractEntityEditPart {
    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        MappingList table = (MappingList)this.getModel();
        entityFigure.setNotImplement(table.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(table.getName());
        for (Map.Entry<AbstractEntityModel, ReusedIdentifier> rk : table.getReusedIdentifieres().entrySet()) {
            for (Identifier identifier : rk.getValue().getIdentifires()) {
                entityFigure.addRelationship(identifier.getName());
            }
        }
        this.setupColor((IFigure)entityFigure, ModelAppearance.MAPPING_LIST);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new MappingListComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ReconnectableNodeEditPolicy());
    }

    @Override
    protected void onDoubleClicked() {
        logger.debug(this.getClass() + "#onDoubleClicked()");
        MappingList table = (MappingList)this.getModel();
        TableEditDialog dialog = new TableEditDialog(this.getViewer().getControl().getShell(), "\u5bfe\u5fdc\u8868\u7de8\u96c6", table);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            List<EditAttribute> editAttributeList = dialog.getEditAttributeList();
            this.addAttributeEditCommands(ccommand, table, editAttributeList);
            ModelEditCommand command = new ModelEditCommand(table, dialog.getEditedValue());
            ccommand.add((Command)command);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)ccommand);
        }
    }

    private static class MappingListComponentEditPolicy
    extends ComponentEditPolicy {
        private MappingListComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            MappingList model = (MappingList)this.getHost().getModel();
            AbstractConnectionModel creationRelationship = (AbstractConnectionModel)model.findCreationRelationship().getSource();
            return new TableDeleteCommand(model, creationRelationship);
        }
    }
}

