/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.imagegenerator;

import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.tmdmaker.imagegenerator.GeneratorWrapper;
import jp.sourceforge.tmdmaker.imagegenerator.generator.RasterImageGenerator;
import jp.sourceforge.tmdmaker.imagegenerator.generator.SVGImageGenerator;
import org.eclipse.draw2d.IFigure;

public class Draw2dToImageConverter {
    private Map<String, GeneratorWrapper> generatorMap = new LinkedHashMap<String, GeneratorWrapper>();
    private static final int IMAGE_SVG = -1;

    public Draw2dToImageConverter() {
        RasterImageGenerator rasterImageGenerator = new RasterImageGenerator();
        SVGImageGenerator svgImageGenerator = new SVGImageGenerator();
        this.generatorMap.put("jpg", new GeneratorWrapper(4, rasterImageGenerator));
        this.generatorMap.put("png", new GeneratorWrapper(5, rasterImageGenerator));
        this.generatorMap.put("gif", new GeneratorWrapper(2, rasterImageGenerator));
        this.generatorMap.put("tiff", new GeneratorWrapper(6, rasterImageGenerator));
        this.generatorMap.put("bmp", new GeneratorWrapper(0, rasterImageGenerator));
        this.generatorMap.put("svg", new GeneratorWrapper(-1, svgImageGenerator));
    }

    public String[] getExtensions() {
        return this.generatorMap.keySet().toArray(new String[this.generatorMap.size()]);
    }

    public void execute(IFigure figure, String file, String extention) {
        this.generatorMap.get(extention).execute(file, figure);
    }
}

