/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.component;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.dialog.IndexEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditImplementAttribute;
import jp.sourceforge.tmdmaker.dialog.model.EditImplementEntity;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.KeyModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class IndexSettingPanel
extends Composite {
    private int selectColumnIndex = -1;
    private EditImplementEntity implementModel;
    private Table indexTable = null;
    private Button addButton = null;
    private Button deleteButton = null;
    private Button updateButton = null;

    public IndexSettingPanel(Composite parent, int style, EditImplementEntity model) {
        super(parent, style);
        this.initialize();
        this.implementModel = model;
    }

    private void initialize() {
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 1;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 150;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.indexTable = new Table((Composite)this, 2);
        this.indexTable.setHeaderVisible(true);
        this.indexTable.setLayoutData((Object)gridData);
        this.indexTable.setLinesVisible(true);
        this.addButton = new Button((Composite)this, 0);
        this.addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.addButton.setText("\u8ffd\u52a0");
        this.updateButton = new Button((Composite)this, 0);
        this.updateButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.updateButton.setText("\u66f4\u65b0");
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("widgetSelected()");
                if (IndexSettingPanel.this.selectColumnIndex == -1) {
                    return;
                }
                KeyModel model = IndexSettingPanel.this.implementModel.getKeyModel(IndexSettingPanel.this.selectColumnIndex);
                ArrayList<IAttribute> notSelectedAttributes = new ArrayList<IAttribute>();
                for (EditImplementAttribute ea : IndexSettingPanel.this.implementModel.getAttributes()) {
                    notSelectedAttributes.add(ea.getOriginalAttribute());
                }
                IndexEditDialog dialog = new IndexEditDialog(IndexSettingPanel.this.getShell(), model, IndexSettingPanel.this.implementModel.getAttributes());
                if (dialog.open() == 0) {
                    KeyModel keyModel = dialog.getKeyModel();
                    IndexSettingPanel.this.implementModel.replaceKeyModel(IndexSettingPanel.this.selectColumnIndex, keyModel);
                }
            }
        });
        this.deleteButton = new Button((Composite)this, 0);
        this.deleteButton.setText("\u524a\u9664");
        this.deleteButton.setLayoutData((Object)gridData1);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("widgetSelected()");
                if (IndexSettingPanel.this.selectColumnIndex == -1) {
                    return;
                }
                IndexSettingPanel.this.implementModel.removeKeyModel(IndexSettingPanel.this.selectColumnIndex);
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("widgetSelected()");
                ArrayList<IAttribute> notSelectedAttributes = new ArrayList<IAttribute>();
                for (EditImplementAttribute ea : IndexSettingPanel.this.implementModel.getAttributes()) {
                    notSelectedAttributes.add(ea.getOriginalAttribute());
                }
                IndexEditDialog dialog = new IndexEditDialog(IndexSettingPanel.this.getShell(), IndexSettingPanel.this.implementModel.getImplementName(), IndexSettingPanel.this.implementModel.getAttributes());
                if (dialog.open() == 0) {
                    KeyModel keyModel = dialog.getKeyModel();
                    IndexSettingPanel.this.implementModel.addKeyModel(keyModel);
                }
            }
        });
        TableColumn tableColumn = new TableColumn(this.indexTable, 0);
        tableColumn.setWidth(150);
        tableColumn.setText("\u5c5e\u6027\u540d");
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(318, 176));
    }

    private void setupTableColumns() {
        int columnSize = this.indexTable.getColumnCount() - 1;
        int keyCount = this.implementModel.getKeyModels().size();
        TableColumn[] columns = this.indexTable.getColumns();
        int i = 0;
        while (i < columnSize - keyCount) {
            columns[i + 1].dispose();
            ++i;
        }
        i = columnSize;
        while (i < keyCount) {
            TableColumn tableColumn = new TableColumn(this.indexTable, 0);
            tableColumn.setWidth(60);
            tableColumn.setAlignment(0x1000000);
            tableColumn.setText(String.valueOf(i + 1));
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn selectColumn = (TableColumn)e.widget;
                    System.out.println("select column is " + selectColumn.getText());
                    TableColumn[] columns = IndexSettingPanel.this.indexTable.getColumns();
                    IndexSettingPanel.this.selectColumnIndex = -1;
                    int i = 0;
                    while (i < columns.length) {
                        columns[i].setImage(null);
                        if (columns[i].equals(selectColumn)) {
                            IndexSettingPanel.this.selectColumnIndex = i - 1;
                        }
                        ++i;
                    }
                    selectColumn.setImage(TMDPlugin.getImage("icons/column_select.gif"));
                }
            });
            ++i;
        }
    }

    public void updateTable() {
        this.setupTableColumns();
        this.indexTable.removeAll();
        int size = this.implementModel.getKeyModels().size();
        if (size < this.selectColumnIndex) {
            this.selectColumnIndex = size;
        }
        int i = 0;
        while (i < size) {
            TableColumn column = this.indexTable.getColumn(i + 1);
            if (this.implementModel.getKeyModel(i).isMasterKey()) {
                column.setText("M");
            } else {
                column.setText(String.valueOf(i + 1));
            }
            ++i;
        }
        for (EditImplementAttribute attribute : this.implementModel.getAttributes()) {
            TableItem item = new TableItem(this.indexTable, 0);
            item.setText(0, attribute.getName());
            List<String> keyOrders = attribute.getKeyOrders();
            int orderSize = keyOrders.size();
            int i2 = 0;
            while (i2 < orderSize) {
                item.setText(i2 + 1, keyOrders.get(i2));
                ++i2;
            }
        }
    }
}

