/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.beans.PropertyChangeEvent;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.dialog.AttributeDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractTMDEditPart;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.property.AttributePropertySource;
import jp.sourceforge.tmdmaker.property.IPropertyAvailable;
import jp.sourceforge.tmdmaker.ui.command.AttributeEditCommand;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;

public class AttributeEditPart
extends AbstractTMDEditPart<Attribute>
implements IPropertyAvailable {
    public AttributeEditPart(Attribute attribute) {
        this.setModel(attribute);
    }

    protected IFigure createFigure() {
        Label label = new Label();
        label.setText(this.createAttributeName((Attribute)this.getModel()));
        label.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        label.setLabelAlignment(1);
        return label;
    }

    private String createAttributeName(Attribute attribute) {
        StringBuilder name = new StringBuilder(attribute.getName());
        if (attribute.isDerivation()) {
            name.append("(D)");
        }
        return name.toString();
    }

    protected void createEditPolicies() {
    }

    @Override
    protected void onDoubleClicked() {
        EditAttribute edited;
        EditAttribute edit = new EditAttribute((IAttribute)this.getModel());
        AttributeDialog dialog = new AttributeDialog(this.getViewer().getControl().getShell(), edit);
        if (dialog.open() == 0 && (edited = dialog.getEditedValue()).isEdited()) {
            System.out.println("edited");
            Attribute editedValueAttribute = new Attribute();
            edited.copyTo((IAttribute)editedValueAttribute);
            IAttribute original = edited.getOriginalAttribute();
            AbstractEntityModel entity = (AbstractEntityModel)this.getParent().getModel();
            AttributeEditCommand editCommand = new AttributeEditCommand(original, (IAttribute)editedValueAttribute, entity);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)editCommand);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_name")) {
            logger.debug("Handle Name Event.");
            this.handleNameChange(evt);
        } else {
            logger.warn("Not Handle Event Occured.");
        }
    }

    protected void refreshVisuals() {
        Label f = (Label)this.getFigure();
        f.setText(this.createAttributeName((Attribute)this.getModel()));
        this.getParent().refresh();
    }

    protected void handleNameChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    @Override
    public IPropertySource getPropertySource(TMDEditor editor) {
        return new AttributePropertySource(editor, (Attribute)this.getModel());
    }
}

