/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import jp.sourceforge.tmdmaker.dialog.CombinationTableEditDialog;
import jp.sourceforge.tmdmaker.dialog.ModelEditDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityModelEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.CombinationTable;
import jp.sourceforge.tmdmaker.ui.command.TableDeleteCommand;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class CombinationTableEditPart
extends AbstractEntityModelEditPart<CombinationTable> {
    public CombinationTableEditPart(CombinationTable table) {
        this.setModel(table);
    }

    @Override
    protected void updateFigure(IFigure figure) {
        logger.debug(this.getClass() + "#updateFigure()");
        EntityFigure entityFigure = (EntityFigure)figure;
        CombinationTable table = (CombinationTable)this.getModel();
        entityFigure.setEntityType(table.getCombinationTableType().getLabel());
        entityFigure.setNotImplement(table.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(table.getName());
        entityFigure.addRelationship(this.extractRelationship(table));
        entityFigure.setColor(this.getForegroundColor(), this.getBackgroundColor());
    }

    @Override
    protected ModelAppearance getAppearance() {
        return ModelAppearance.COMBINATION_TABLE;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new CombinationTableComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    @Override
    protected void onDoubleClicked() {
        logger.debug(this.getClass() + "#onDoubleClicked()");
        ModelEditDialog<CombinationTable> dialog = this.getDialog();
        if (dialog.open() != 0) {
            return;
        }
        CompoundCommand ccommand = this.createEditCommand(dialog.getEditAttributeList(), (AbstractEntityModel)dialog.getEditedValue());
        this.executeEditCommand(ccommand.unwrap());
    }

    @Override
    protected ModelEditDialog<CombinationTable> getDialog() {
        return new CombinationTableEditDialog(this.getControllShell(), "\u5bfe\u7167\u8868\u7de8\u96c6", (CombinationTable)this.getModel());
    }

    private static class CombinationTableComponentEditPolicy
    extends ComponentEditPolicy {
        private CombinationTableComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            CombinationTable model = (CombinationTable)this.getHost().getModel();
            AbstractConnectionModel creationRelationship = (AbstractConnectionModel)model.findCreationRelationship().getSource();
            return new TableDeleteCommand((AbstractEntityModel)model, creationRelationship);
        }
    }
}

