/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import jp.sourceforge.tmdmaker.dialog.ModelEditDialog;
import jp.sourceforge.tmdmaker.dialog.TableEditDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityModelEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.RecursiveTable;
import jp.sourceforge.tmdmaker.ui.command.TableDeleteCommand;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class RecursiveTableEditPart
extends AbstractEntityModelEditPart<RecursiveTable> {
    public RecursiveTableEditPart(RecursiveTable table) {
        this.setModel(table);
    }

    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        RecursiveTable table = (RecursiveTable)this.getModel();
        entityFigure.setNotImplement(table.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(table.getName());
        entityFigure.addRelationship(this.extractRelationship(table));
        entityFigure.setColor(this.getForegroundColor(), this.getBackgroundColor());
    }

    @Override
    protected ModelAppearance getAppearance() {
        return ModelAppearance.RECURSIVE_TABLE;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RecursiveTableComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    @Override
    protected ModelEditDialog<RecursiveTable> getDialog() {
        return new TableEditDialog<RecursiveTable>(this.getControllShell(), "\u518d\u5e30\u8868\u7de8\u96c6", (AbstractEntityModel)this.getModel());
    }

    private static class RecursiveTableComponentEditPolicy
    extends ComponentEditPolicy {
        private RecursiveTableComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            RecursiveTable model = (RecursiveTable)this.getHost().getModel();
            return new TableDeleteCommand((AbstractEntityModel)model, (AbstractConnectionModel)model.getModelTargetConnections().get(0));
        }
    }
}

