/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.preferences.appearance;

import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.ui.preferences.IPreferenceListener;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.AppearanceSetting;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class AppearancePreferenceListener
implements IPreferenceListener {
    public void propertyChange(PropertyChangeEvent event) {
        AppearanceSetting config = AppearanceSetting.getInstance();
        if (event.getProperty().equals("entityColorEnablePreference")) {
            System.out.println("P_ENTITY_COLOR_ENABLED");
            config.setColorEnabled(this.convertBooleanIfNeed(event.getNewValue()));
            TMDPlugin.getDefault().update();
            return;
        }
        ModelAppearance[] modelAppearanceArray = ModelAppearance.values();
        int n = modelAppearanceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelAppearance a = modelAppearanceArray[n2];
            if (event.getProperty().equals(a.getBackgroundColorPropertyName())) {
                System.out.println(a.getBackgroundColorPropertyName());
                RGB background = this.convertRGBIfNeed(event.getNewValue());
                config.setBackground(a, background);
                TMDPlugin.getDefault().update();
            } else if (event.getProperty().equals(a.getFontColorPropertyName())) {
                System.out.println(a.getFontColorPropertyName());
                RGB font = this.convertRGBIfNeed(event.getNewValue());
                config.setFont(a, font);
                TMDPlugin.getDefault().update();
            }
            ++n2;
        }
    }

    private RGB convertRGBIfNeed(Object value) {
        if (value instanceof RGB) {
            return (RGB)value;
        }
        return StringConverter.asRGB((String)((String)value));
    }

    private boolean convertBooleanIfNeed(Object value) {
        System.out.println(value);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return StringConverter.asBoolean((String)((String)value));
    }

    @Override
    public void preferenceStart(IPreferenceStore store) {
        AppearanceSetting config = AppearanceSetting.getInstance();
        ModelAppearance[] modelAppearanceArray = ModelAppearance.values();
        int n = modelAppearanceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelAppearance a = modelAppearanceArray[n2];
            RGB background = StringConverter.asRGB((String)store.getString(a.getBackgroundColorPropertyName()));
            RGB font = StringConverter.asRGB((String)store.getString(a.getFontColorPropertyName()));
            config.setColors(a, background, font);
            ++n2;
        }
        config.setColorEnabled(store.getBoolean("entityColorEnablePreference"));
        TMDPlugin.getDefault().update();
    }
}

