/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.ConnectableElement;

public abstract class AbstractConnectionModel
extends ConnectableElement {
    private ConnectableElement source;
    private ConnectableElement target;
    protected int sourceXp = -1;
    protected int sourceYp = -1;
    protected int targetXp = -1;
    protected int targetYp = -1;
    public static final String PROPERTY_SOURCE_CARDINALITY = "_property_source_cardinality";
    public static final String PROPERTY_TARGET_CARDINALITY = "_property_target_cardinality";
    public static final String PROPERTY_CONNECTION = "_property_connection";

    public void connect() {
        this.attachSource();
        this.attachTarget();
    }

    public void disconnect() {
        this.detachSource();
        this.detachTarget();
    }

    public void attachSource() {
        if (!this.source.getModelSourceConnections().contains(this)) {
            this.source.addSourceConnection(this);
        }
    }

    public void attachTarget() {
        if (!this.target.getModelTargetConnections().contains(this)) {
            this.target.addTargetConnection(this);
        }
    }

    public void detachSource() {
        if (this.source != null) {
            this.source.removeSourceConnection(this);
        }
    }

    public void detachTarget() {
        if (this.target != null) {
            this.target.removeTargetConnection(this);
        }
    }

    public ConnectableElement getSource() {
        return this.source;
    }

    public void setSource(ConnectableElement source) {
        this.source = source;
    }

    public ConnectableElement getTarget() {
        return this.target;
    }

    public void setTarget(ConnectableElement target) {
        this.target = target;
    }

    public void fireParentMoved() {
        this.firePropertyChange(PROPERTY_CONNECTION, null, null);
    }

    public abstract boolean isDeletable();

    public abstract String getSourceName();

    public abstract String getTargetName();

    public int getSourceXp() {
        return this.sourceXp;
    }

    public int getSourceYp() {
        return this.sourceYp;
    }

    public int getTargetXp() {
        return this.targetXp;
    }

    public int getTargetYp() {
        return this.targetYp;
    }

    public void setSourceLocationp(int sourceXp, int sourceYp) {
        this.sourceXp = sourceXp;
        this.sourceYp = sourceYp;
        this.firePropertyChange(PROPERTY_CONNECTION, null, null);
    }

    public void setTargetLocationp(int targetXp, int targetYp) {
        this.targetXp = targetXp;
        this.targetYp = targetYp;
        this.firePropertyChange(PROPERTY_CONNECTION, null, null);
    }

    public boolean isConnected() {
        return this.source != null && this.source.getModelSourceConnections().contains(this) && this.target != null && this.target.getModelTargetConnections().contains(this);
    }
}

