/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.Iterator;
import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.CombinationTableType;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;

public class CombinationTable
extends AbstractEntityModel {
    public static final String COMBINATION_TABLE_SUFFIX = ".\u5bfe\u7167\u8868";
    private CombinationTableType combinationTableType = CombinationTableType.L_TRUTH;

    @Override
    public ReusedIdentifier createReusedIdentifier() {
        ReusedIdentifier returnValue = new ReusedIdentifier(this.keyModels.getSarogateKey());
        this.checkDuplicateTargetReusedIdentifieres();
        for (Map.Entry rk : this.reusedIdentifieres.entrySet()) {
            returnValue.addAll(((ReusedIdentifier)rk.getValue()).getIdentifires());
        }
        return returnValue;
    }

    @Override
    public Map<AbstractEntityModel, ReusedIdentifier> getReusedIdentifieres() {
        this.checkDuplicateTargetReusedIdentifieres();
        return super.getReusedIdentifieres();
    }

    private Map.Entry<AbstractEntityModel, ReusedIdentifier> getSource() {
        Iterator<Map.Entry<AbstractEntityModel, ReusedIdentifier>> it = super.getReusedIdentifieres().entrySet().iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    private Map.Entry<AbstractEntityModel, ReusedIdentifier> getTarget() {
        Iterator<Map.Entry<AbstractEntityModel, ReusedIdentifier>> it = super.getReusedIdentifieres().entrySet().iterator();
        if (!it.hasNext()) {
            return null;
        }
        it.next();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    private void checkDuplicateTargetReusedIdentifieres() {
        Map.Entry<AbstractEntityModel, ReusedIdentifier> source = this.getSource();
        Map.Entry<AbstractEntityModel, ReusedIdentifier> target = this.getTarget();
        if (source == null || target == null) {
            return;
        }
        for (IdentifierRef i : target.getValue().getIdentifires()) {
            if (this.containIdentifier(source.getValue(), i)) {
                i.setDuplicate(true);
                continue;
            }
            i.setDuplicate(false);
        }
    }

    private boolean containIdentifier(ReusedIdentifier source, IdentifierRef target) {
        for (IdentifierRef s : source.getIdentifires()) {
            if (!target.getName().equals(s.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEntityTypeEditable() {
        return false;
    }

    @Override
    public boolean isDeletable() {
        return this.getModelSourceConnections().size() == 0 && this.getModelTargetConnections().size() == 1;
    }

    public RelatedRelationship findCreationRelationship() {
        AbstractConnectionModel r = this.getModelTargetConnections().get(0);
        assert (r instanceof RelatedRelationship);
        return (RelatedRelationship)r;
    }

    public CombinationTableType getCombinationTableType() {
        return this.combinationTableType;
    }

    public void setCombinationTableType(CombinationTableType combinationTableType) {
        this.combinationTableType = combinationTableType;
    }

    @Override
    public CombinationTable getCopy() {
        CombinationTable copy = new CombinationTable();
        this.copyTo(copy);
        return copy;
    }

    @Override
    public void copyTo(AbstractEntityModel to) {
        if (to instanceof CombinationTable) {
            ((CombinationTable)to).setCombinationTableType(this.getCombinationTableType());
        }
        super.copyTo(to);
    }

    @Override
    public void fireIdentifierChanged(AbstractConnectionModel callConnection) {
        this.checkDuplicateTargetReusedIdentifieres();
        super.fireIdentifierChanged(callConnection);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }
}

