/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;

public class Entity
extends AbstractEntityModel {
    private String physicalName = "";
    private String description = "";
    private Identifier identifier = new Identifier();

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String physicalName) {
        this.physicalName = physicalName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        Identifier oldValue = this.identifier;
        this.identifier = identifier;
        this.firePropertyChange("_property_identifier", oldValue, identifier);
    }

    public void setIdentifierName(String identifierName) {
        String oldValue = this.identifier.getName();
        this.identifier.setName(identifierName);
        if (oldValue == null || !oldValue.equals(identifierName)) {
            this.firePropertyChange("_property_identifier", oldValue, this.identifier);
            this.fireIdentifierChanged(null);
        }
    }

    @Override
    public ReusedIdentifier createReusedIdentifier() {
        return new ReusedIdentifier(this.identifier, this.keyModels.getSarogateKey());
    }

    @Override
    public boolean isEntityTypeEditable() {
        return this.getModelSourceConnections().size() == 0 && this.getModelTargetConnections().size() == 0;
    }

    @Override
    public boolean isDeletable() {
        if (this.getEntityType() == EntityType.EVENT) {
            return this.getModelSourceConnections().size() == 0;
        }
        return this.getModelSourceConnections().size() == 0 && this.getModelTargetConnections().size() == 0;
    }

    @Override
    public void copyTo(AbstractEntityModel to) {
        if (to instanceof Entity) {
            Entity toEntity = (Entity)to;
            toEntity.setIdentifierName(this.getIdentifier().getName());
            toEntity.getIdentifier().copyFrom(this.getIdentifier());
        }
        super.copyTo(to);
    }

    @Override
    public Entity getCopy() {
        Entity copy = new Entity();
        this.copyTo(copy);
        return copy;
    }

    @Override
    public int calcurateMaxIdentifierRefSize() {
        int i = this.getIdentifier().getName().length();
        return Math.max(super.calcurateMaxIdentifierRefSize(), i);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }
}

