/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.dialog.CommonAttributeDialog;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.IAttribute;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;

public class CommonAttributeSettingAction
extends Action {
    private GraphicalViewer viewer;
    public static final String ID = "CommonAtributeSettingAction";

    public CommonAttributeSettingAction(GraphicalViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.CommonAttributeSettings);
        this.setId(ID);
    }

    public void run() {
        Diagram diagram = (Diagram)this.viewer.getContents().getModel();
        CommonAttributeDialog dialog = new CommonAttributeDialog(this.viewer.getControl().getShell(), diagram.getCommonAttributes());
        if (dialog.open() == 0) {
            this.viewer.getEditDomain().getCommandStack().execute((Command)new CommonAttributeEditCommand(diagram, dialog.getEditedAttributes()));
        }
    }

    private static class CommonAttributeEditCommand
    extends Command {
        private Diagram diagram;
        private List<IAttribute> newAttributes;
        private List<IAttribute> oldAttributes;

        public CommonAttributeEditCommand(Diagram diagram, List<IAttribute> attributes) {
            this.diagram = diagram;
            this.oldAttributes = diagram.getCommonAttributes();
            this.newAttributes = attributes;
        }

        public void execute() {
            this.diagram.setCommonAttributes(this.newAttributes);
        }

        public void undo() {
            this.diagram.setCommonAttributes(this.oldAttributes);
        }
    }
}

