/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.action.AbstractEntitySelectionAction;
import jp.sourceforge.tmdmaker.dialog.MultivalueOrEntityCreateDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractModelEditPart;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.MultivalueOrRelationship;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class MultivalueOrCreateAction
extends AbstractEntitySelectionAction {
    public static final String ID = "_MO";

    public MultivalueOrCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.CreateMultivalueOr);
        this.setId(ID);
    }

    public void run() {
        MultivalueOrEntityCreateDialog dialog = new MultivalueOrEntityCreateDialog(this.getPart().getViewer().getControl().getShell());
        if (dialog.open() == 0) {
            MultivalueOrCreateCommand command = new MultivalueOrCreateCommand(this.getModel(), dialog.getInputTypeName());
            this.execute(command);
        }
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof AbstractModelEditPart) {
            return ((AbstractModelEditPart)selection).canCreateMultivalueOr();
        }
        return false;
    }

    private static class MultivalueOrCreateCommand
    extends Command {
        private MultivalueOrRelationship relationship;

        public MultivalueOrCreateCommand(AbstractEntityModel model, String typeName) {
            this.relationship = new MultivalueOrRelationship(model, typeName);
        }

        public void execute() {
            this.relationship.connect();
        }

        public void undo() {
            this.relationship.disconnect();
        }
    }
}

