/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.action.AbstractEntitySelectionAction;
import jp.sourceforge.tmdmaker.dialog.VirtualEntityCreateDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractModelEditPart;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Entity2VirtualEntityRelationship;
import jp.sourceforge.tmdmaker.model.VirtualEntityType;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class VirtualEntityCreateAction
extends AbstractEntitySelectionAction {
    public static final String ID = "_VE";

    public VirtualEntityCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.CreateVirtualEntity);
        this.setId(ID);
    }

    public void run() {
        VirtualEntityCreateDialog dialog = new VirtualEntityCreateDialog(this.getPart().getViewer().getControl().getShell());
        if (dialog.open() == 0) {
            this.execute(new VirtualEntityCreateCommand(this.getModel(), dialog.getInputVirtualEntityName(), dialog.getInputVirtualEntityType()));
        }
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof AbstractModelEditPart) {
            return ((AbstractModelEditPart)selection).canCreateVirtualEntity();
        }
        return false;
    }

    private static class VirtualEntityCreateCommand
    extends Command {
        private Entity2VirtualEntityRelationship relationship;

        public VirtualEntityCreateCommand(AbstractEntityModel model, String virtualEntityName, VirtualEntityType type) {
            this.relationship = new Entity2VirtualEntityRelationship(model, virtualEntityName, type);
        }

        public void execute() {
            this.relationship.connect();
        }

        public void undo() {
            this.relationship.disconnect();
        }
    }
}

