/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractSubsetType;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity2SubsetTypeRelationship;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType2SubsetRelationship;

public class SubsetType
extends AbstractSubsetType<AbstractEntityModel> {
    private SubsetTypeValue subsetType = SubsetTypeValue.SAME;
    public static final String PROPERTY_PARTITION = "_property_partition";
    public static final String PROPERTY_TYPE = "_property_type";
    private IAttribute partitionAttribute;
    private boolean exceptNull;

    @Override
    public List<SubsetEntity> getSubsetList() {
        ArrayList<SubsetEntity> results = new ArrayList<SubsetEntity>();
        for (AbstractConnectionModel c : this.getModelSourceConnections()) {
            ConnectableElement m = c.getTarget();
            if (!(m instanceof SubsetEntity)) continue;
            results.add((SubsetEntity)m);
        }
        return results;
    }

    public SubsetTypeValue getSubsetType() {
        return this.subsetType;
    }

    public void setSubsetType(SubsetTypeValue subsetType) {
        SubsetTypeValue oldValue = this.subsetType;
        this.subsetType = subsetType;
        this.firePropertyChange(PROPERTY_TYPE, (Object)oldValue, (Object)this.subsetType);
        this.firePartitionChanged();
    }

    public IAttribute getPartitionAttribute() {
        return this.partitionAttribute;
    }

    public void setPartitionAttribute(IAttribute partitionAttribute) {
        IAttribute oldValue = this.partitionAttribute;
        this.partitionAttribute = partitionAttribute;
        this.firePropertyChange(PROPERTY_PARTITION, oldValue, partitionAttribute);
        this.firePartitionChanged();
    }

    public boolean isExceptNull() {
        return this.exceptNull;
    }

    public void setExceptNull(boolean exceptNull) {
        boolean oldValue = this.exceptNull;
        this.exceptNull = exceptNull;
        this.firePropertyChange(PROPERTY_PARTITION, oldValue, this.partitionAttribute);
        this.firePartitionChanged();
    }

    public void firePartitionChanged() {
        this.notifySuperset();
        this.nofityRelationship();
        this.notifySubsetEntity();
    }

    private Entity2SubsetTypeRelationship getEntity2SubsetTypeRelationship() {
        if (this.getModelTargetConnections().size() > 0) {
            return (Entity2SubsetTypeRelationship)this.getModelTargetConnections().get(0);
        }
        return null;
    }

    @Override
    public AbstractEntityModel getSuperset() {
        Entity2SubsetTypeRelationship r = this.getEntity2SubsetTypeRelationship();
        if (r != null) {
            return (AbstractEntityModel)r.getSource();
        }
        return null;
    }

    private void notifySuperset() {
        AbstractEntityModel superset = this.getSuperset();
        if (superset != null) {
            superset.firePropertyChange(PROPERTY_PARTITION, null, (Object)this.getSubsetType());
        }
    }

    private void nofityRelationship() {
        Entity2SubsetTypeRelationship r = this.getEntity2SubsetTypeRelationship();
        if (r != null) {
            r.firePartitionChanged();
        }
    }

    private void notifySubsetEntity() {
        for (SubsetEntity s : this.getSubsetList()) {
            s.firePropertyChange(PROPERTY_PARTITION, null, (Object)this.getSubsetType());
        }
    }

    public boolean isSameType() {
        return this.subsetType.equals((Object)SubsetTypeValue.SAME);
    }

    public boolean isNew() {
        return this.getModelTargetConnections().size() == 0;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public boolean removeSubsetEntity(SubsetEntity subsetEntity) {
        if (!subsetEntity.isDeletable()) {
            return false;
        }
        for (SubsetEntity s : this.getSubsetList()) {
            if (!s.equals(subsetEntity)) continue;
            Diagram diagram = subsetEntity.getDiagram();
            SubsetType2SubsetRelationship r = (SubsetType2SubsetRelationship)s.findRelationshipFromTargetConnections(SubsetType2SubsetRelationship.class).get(0);
            r.disconnect();
            diagram.removeChild(subsetEntity);
            return true;
        }
        return false;
    }

    public boolean hasSubsetEntity() {
        return this.getModelSourceConnections().size() != 0;
    }

    public static enum SubsetTypeValue {
        SAME,
        DIFFERENT;

    }
}

