/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractSubsetType;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;

public class VirtualSupersetType
extends AbstractSubsetType<VirtualSuperset> {
    public static final String PROPERTY_SUPERSET_TYPE = "_property_superset_type";
    protected Map<AbstractEntityModel, ReusedIdentifier> reusedIdentifieres = new LinkedHashMap<AbstractEntityModel, ReusedIdentifier>();
    private boolean applyAttribute = false;

    public VirtualSupersetType() {
        this.setApplyAttribute(true);
    }

    public boolean isApplyAttribute() {
        return this.applyAttribute;
    }

    public void setApplyAttribute(boolean applyAttribute) {
        boolean oldValue = this.applyAttribute;
        this.applyAttribute = applyAttribute;
        this.firePropertyChange(PROPERTY_SUPERSET_TYPE, oldValue, this.applyAttribute);
    }

    public void addReusedIdentifier(AbstractEntityModel source) {
        this.addReusedIdentifier(source, source.createReusedIdentifier());
    }

    protected void addReusedIdentifier(AbstractEntityModel source, ReusedIdentifier reused) {
        this.reusedIdentifieres.put(source, reused);
        this.notifyRelationshipChanged();
    }

    public ReusedIdentifier removeReusedIdentifier(AbstractEntityModel source) {
        ReusedIdentifier removed = this.reusedIdentifieres.remove(source);
        this.notifyRelationshipChanged();
        return removed;
    }

    private void notifyRelationshipChanged() {
        ((AbstractEntityModel)this.getModelSourceConnections().get(0).getTarget()).fireIdentifierChanged(null);
    }

    public Map<AbstractEntityModel, ReusedIdentifier> getReusedIdentifieres() {
        return this.reusedIdentifieres;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public VirtualSuperset getSuperset() {
        if (this.getModelSourceConnections().size() > 0) {
            AbstractConnectionModel r = this.getModelSourceConnections().get(0);
            return (VirtualSuperset)r.getTarget();
        }
        return null;
    }

    @Override
    public List<AbstractEntityModel> getSubsetList() {
        ArrayList<AbstractEntityModel> list = new ArrayList<AbstractEntityModel>();
        for (AbstractConnectionModel c : this.getModelTargetConnections()) {
            ConnectableElement m = c.getSource();
            if (!(m instanceof AbstractEntityModel)) continue;
            list.add((AbstractEntityModel)m);
        }
        return list;
    }
}

