/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.action.AbstractMultipleSelectionAction;
import jp.sourceforge.tmdmaker.dialog.VirtualSupersetCreateDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityModelEditPart;
import jp.sourceforge.tmdmaker.editpart.AbstractModelEditPart;
import jp.sourceforge.tmdmaker.editpart.DiagramEditPart;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType2VirtualSupersetRelationship;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ConnectionDeleteCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ConstraintChangeCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ModelEditCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.RelationshipConnectionCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.VirtualSubsetReplaceCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.VirtualSupersetTypeChangeCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class VirtualSupersetCreateAction
extends AbstractMultipleSelectionAction {
    public static final String ID = "_VS";

    public VirtualSupersetCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.EditVirtualSuperset);
        this.setId(ID);
    }

    public void run() {
        VirtualSupersetCreateDialog dialog;
        Point pos = this.getControlCursorLocation();
        List<AbstractEntityModel> selectedModels = this.getSelectedModelList();
        Diagram diagram = this.getDiagram();
        VirtualSuperset original = null;
        VirtualSupersetType aggregator = null;
        if (selectedModels.size() > 0 && (original = this.getVirtualSuperset()) != null) {
            selectedModels.remove(original);
            aggregator = original.getVirtualSupersetType();
        }
        if ((dialog = new VirtualSupersetCreateDialog(this.getControl().getShell(), diagram, original, selectedModels)).open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            VirtualSuperset edited = dialog.getEditedValue();
            aggregator = dialog.getEditedAggregator();
            if (original == null) {
                List<AbstractEntityModel> selection = dialog.getSelection();
                if (selection.size() == 0) {
                    return;
                }
                VirtualSupersetType2VirtualSupersetRelationship r = new VirtualSupersetType2VirtualSupersetRelationship(edited.getName(), selection);
                VirtualSuperset virtualSuperset = r.getSuperset();
                VirtualSupersetType type = r.getType();
                ccommand.add((Command)new RelationshipConnectionCommand((AbstractConnectionModel)r));
                ccommand.add((Command)new VirtualSupersetTypeChangeCommand(type, aggregator.isApplyAttribute()));
                ccommand.add((Command)new ConstraintChangeCommand((ModelElement)virtualSuperset, pos.x, pos.y));
                ccommand.add((Command)new ConstraintChangeCommand((ModelElement)type, pos.x, pos.y + 50));
            } else {
                List<AbstractEntityModel> selectedList = dialog.getSelection();
                if (selectedList.size() == 0) {
                    ccommand.add((Command)new ConnectionDeleteCommand((AbstractConnectionModel)original.getCreationRelationship()));
                } else {
                    ccommand.add((Command)new ModelEditCommand((AbstractEntityModel)original, (AbstractEntityModel)edited));
                    ccommand.add((Command)new VirtualSupersetTypeChangeCommand(original.getVirtualSupersetType(), dialog.getEditedAggregator().isApplyAttribute()));
                    ccommand.add((Command)new VirtualSubsetReplaceCommand(original, dialog.getSelection()));
                }
            }
            this.execute((Command)ccommand);
        }
    }

    private Control getControl() {
        return ((AbstractEditPart)this.getSelectedObjects().get(0)).getViewer().getControl();
    }

    private Point getControlCursorLocation() {
        Control control = this.getControl();
        Point pos = control.getDisplay().getCursorLocation();
        pos = control.toControl(pos);
        pos.x -= 200;
        pos.y -= 100;
        return pos;
    }

    private Diagram getDiagram() {
        for (Object o : this.getSelectedObjects()) {
            if (o instanceof DiagramEditPart) {
                return (Diagram)((DiagramEditPart)o).getModel();
            }
            if (!(o instanceof AbstractModelEditPart)) continue;
            return (Diagram)((AbstractModelEditPart)o).getParent().getModel();
        }
        return null;
    }

    private VirtualSuperset getVirtualSuperset() {
        List<AbstractEntityModel> list = this.getSelectedModelList();
        for (AbstractEntityModel o : list) {
            if (!(o instanceof VirtualSuperset)) continue;
            return (VirtualSuperset)o;
        }
        for (AbstractEntityModel o : list) {
            VirtualSupersetType type = o.findVirtualSupersetType();
            if (type == null) continue;
            return type.getSuperset();
        }
        return null;
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() >= 1 && this.hasEntityModel()) {
            return true;
        }
        return this.isDiagramSelected();
    }

    private boolean hasEntityModel() {
        for (Object o : this.getSelectedObjects()) {
            if (!(o instanceof AbstractEntityModelEditPart)) continue;
            return true;
        }
        return false;
    }

    private boolean isDiagramSelected() {
        return this.getSelectedObjects().size() == 1 && this.getSelectedObjects().get(0) instanceof DiagramEditPart;
    }
}

