/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.beans.PropertyChangeEvent;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityModelEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.SubsetEntityComponentEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;

public class SubsetEntityEditPart
extends AbstractEntityModelEditPart<SubsetEntity> {
    public SubsetEntityEditPart(SubsetEntity entity) {
        this.setModel(entity);
    }

    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        SubsetEntity entity = (SubsetEntity)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        if (!entity.isSameSubset() || entity.getAttributes().size() != 0) {
            if (entity.isSupersetAnEntity()) {
                entityFigure.setIdentifier(((IdentifierRef)entity.getOriginalReusedIdentifier().getUniqueIdentifiers().get(0)).getName());
            } else {
                for (Identifier i : entity.getOriginalReusedIdentifier().getUniqueIdentifiers()) {
                    entityFigure.addRelationship(i.getName());
                }
            }
            entityFigure.addRelationship(this.extractRelationship(entity));
        }
        entityFigure.setColor(this.getForegroundColor(), this.getBackgroundColor());
    }

    @Override
    protected ModelAppearance getAppearance() {
        ModelAppearance appearance = null;
        if (((SubsetEntity)this.getModel()).getEntityType().equals((Object)EntityType.RESOURCE)) {
            appearance = ModelAppearance.RESOURCE_SUBSET;
        } else if (((SubsetEntity)this.getModel()).getEntityType().equals((Object)EntityType.EVENT)) {
            appearance = ModelAppearance.EVENT_SUBSET;
        }
        return appearance;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_partition")) {
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new SubsetEntityComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }
}

