/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpolicy;

import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.dialog.ModelEditDialog;
import jp.sourceforge.tmdmaker.dialog.TableEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpolicy.AbstractEntityModelEditPolicy;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.SubsetType2SubsetRelationship;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ImplementDerivationModelsDeleteCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.SubsetTypeDeleteCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;

public class SubsetEntityComponentEditPolicy
extends AbstractEntityModelEditPolicy<SubsetEntity> {
    @Override
    protected ModelEditDialog<SubsetEntity> getDialog() {
        return new TableEditDialog<SubsetEntity>(this.getControllShell(), Messages.EditSubset, (AbstractEntityModel)this.getModel());
    }

    private Command getDeleteCommand(AbstractEntityModel editedValue) {
        Object table = this.getModel();
        if (table.isNotImplement() && !editedValue.isNotImplement()) {
            AbstractEntityModel original = ImplementRule.findOriginalImplementModel(table);
            return new ImplementDerivationModelsDeleteCommand((AbstractEntityModel)table, original);
        }
        return null;
    }

    @Override
    protected Command createEditCommand(List<EditAttribute> editAttributeList, AbstractEntityModel editedValue) {
        CompoundCommand ccommand = new CompoundCommand();
        ccommand.add(super.createEditCommand(editAttributeList, editedValue));
        Command deleteCommand = this.getDeleteCommand(editedValue);
        if (deleteCommand != null) {
            ccommand.add(deleteCommand);
        }
        return ccommand.unwrap();
    }

    protected Command createDeleteCommand(GroupRequest deleteRequest) {
        CompoundCommand ccommand = new CompoundCommand();
        SubsetEntityDeleteCommand command1 = new SubsetEntityDeleteCommand(this.getDiagram(), (SubsetEntity)this.getModel());
        ccommand.add((Command)command1);
        if (((SubsetEntity)this.getModel()).isNotImplement()) {
            AbstractEntityModel original = ImplementRule.findOriginalImplementModel(this.getModel());
            ccommand.add((Command)new ImplementDerivationModelsDeleteCommand((AbstractEntityModel)this.getModel(), original));
        }
        SubsetType2SubsetRelationship relationship = (SubsetType2SubsetRelationship)((SubsetEntity)this.getModel()).findRelationshipFromTargetConnections(SubsetType2SubsetRelationship.class).get(0);
        SubsetTypeDeleteCommand command2 = new SubsetTypeDeleteCommand(this.getDiagram(), (SubsetType)relationship.getSource());
        ccommand.add((Command)command2);
        return ccommand;
    }

    private static class SubsetEntityDeleteCommand
    extends Command {
        private Diagram diagram;
        private SubsetEntity model;
        private SubsetType2SubsetRelationship subsetType2SubsetEntityRelationship;

        public SubsetEntityDeleteCommand(Diagram diagram, SubsetEntity model) {
            this.diagram = diagram;
            this.model = model;
            this.subsetType2SubsetEntityRelationship = (SubsetType2SubsetRelationship)this.model.findRelationshipFromTargetConnections(SubsetType2SubsetRelationship.class).get(0);
        }

        public boolean canExecute() {
            return this.model.isDeletable();
        }

        public void execute() {
            this.subsetType2SubsetEntityRelationship.disconnect();
            this.diagram.removeChild((AbstractEntityModel)this.model);
        }

        public void undo() {
            this.diagram.addChild((AbstractEntityModel)this.model);
            this.subsetType2SubsetEntityRelationship.connect();
        }
    }
}

