/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import javax.inject.Inject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.RenderedElementUtil;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolItemUpdater;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractContributionItem
extends ContributionItem {
    protected static final String FORCE_TEXT = "FORCE_TEXT";
    protected static final String ICON_URI = "iconURI";
    protected static final String DISABLED_URI = "disabledURI";
    public static final String DISPOSABLE = "IDisposable";
    @Inject
    @Optional
    protected Logger logger;
    @Inject
    private EModelService modelService;
    @Inject
    @Optional
    protected EHelpService helpService;
    protected Widget widget;
    protected Listener menuItemListener;
    protected LocalResourceManager localResourceManager;
    MItem modelItem;
    private ISafeRunnable updateRunner;
    private ISWTResourceUtilities resUtils = null;
    protected IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            AbstractContributionItem.this.update(null);
        }
    };
    private boolean logged = false;

    public AbstractContributionItem() {
    }

    public AbstractContributionItem(String id) {
        super(id);
    }

    public void update() {
        this.update(null);
    }

    public void update(String id) {
        this.updateIcons();
        if (this.widget instanceof MenuItem) {
            this.updateMenuItem();
        } else if (this.widget instanceof ToolItem) {
            this.updateToolItem();
        }
    }

    protected abstract void updateMenuItem();

    protected abstract void updateToolItem();

    @Inject
    void setResourceUtils(IResourceUtilities<ImageDescriptor> utils) {
        this.resUtils = (ISWTResourceUtilities)utils;
    }

    protected Image getImage(String iconURI, LocalResourceManager resourceManager) {
        ImageDescriptor iconDescriptor;
        Image image = null;
        if (iconURI != null && iconURI.length() > 0 && (iconDescriptor = (ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI))) != null) {
            try {
                image = resourceManager.createImage(iconDescriptor);
            }
            catch (DeviceResourceException e) {
                iconDescriptor = ImageDescriptor.getMissingImageDescriptor();
                image = resourceManager.createImage(iconDescriptor);
                Activator.trace((String)"/trace/menus", (String)("failed to create image " + iconURI), (Throwable)e);
            }
        }
        return image;
    }

    protected void updateIcons() {
        if (!(this.widget instanceof Item)) {
            return;
        }
        Item item = (Item)this.widget;
        String iconURI = this.modelItem.getIconURI() != null ? this.modelItem.getIconURI() : "";
        String disabledURI = this.getDisabledIconURI(this.modelItem);
        Object disabledData = item.getData(DISABLED_URI);
        if (disabledData == null) {
            disabledData = "";
        }
        if (!iconURI.equals(item.getData(ICON_URI)) || !disabledURI.equals(disabledData)) {
            LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
            Image iconImage = this.getImage(iconURI, resourceManager);
            item.setImage(iconImage);
            item.setData(ICON_URI, (Object)iconURI);
            if (item instanceof ToolItem) {
                iconImage = this.getImage(disabledURI, resourceManager);
                ((ToolItem)item).setDisabledImage(iconImage);
                item.setData(DISABLED_URI, (Object)disabledURI);
            }
            this.disposeOldImages();
            this.localResourceManager = resourceManager;
        }
    }

    private String getDisabledIconURI(MItem toolItem) {
        Object obj = toolItem.getTransientData().get("e4_disabled_icon_image_key");
        return obj instanceof String ? (String)obj : "";
    }

    protected void disposeOldImages() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
            this.localResourceManager = null;
        }
    }

    public void setModel(MItem item) {
        this.modelItem = item;
        this.setId(this.modelItem.getElementId());
        this.updateVisible();
    }

    public MItem getModel() {
        return this.modelItem;
    }

    public void setParent(IContributionManager parent) {
        IMenuManager menuMgr;
        if (this.getParent() instanceof IMenuManager) {
            menuMgr = (IMenuManager)this.getParent();
            menuMgr.removeMenuListener(this.menuListener);
        }
        if (parent instanceof IMenuManager) {
            menuMgr = (IMenuManager)parent;
            menuMgr.addMenuListener(this.menuListener);
        }
        super.setParent(parent);
    }

    public void fill(Menu menu, int index) {
        if (this.modelItem == null) {
            return;
        }
        if (this.widget != null) {
            return;
        }
        int style = 8;
        if (this.modelItem.getType() == ItemType.PUSH) {
            style = 8;
        } else if (this.modelItem.getType() == ItemType.CHECK) {
            style = 32;
        } else if (this.modelItem.getType() == ItemType.RADIO) {
            style = 16;
        }
        MenuItem item = null;
        item = index >= 0 ? new MenuItem(menu, style, index) : new MenuItem(menu, style);
        item.setData((Object)this);
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        item.addListener(14, this.getItemListener());
        item.addListener(28, this.getItemListener());
        this.widget = item;
        this.modelItem.setWidget((Object)this.widget);
        this.widget.setData("modelElement", (Object)this.modelItem);
        this.update(null);
        this.postMenuFill();
    }

    protected void postMenuFill() {
    }

    public void fill(ToolBar parent, int index) {
        if (this.modelItem == null) {
            return;
        }
        if (this.widget != null) {
            return;
        }
        boolean isDropdown = false;
        if (this.modelItem instanceof MToolItem) {
            MMenu menu = ((MToolItem)this.modelItem).getMenu();
            isDropdown = menu != null;
        }
        int style = 8;
        if (isDropdown) {
            style = 4;
        } else if (this.modelItem.getType() == ItemType.CHECK) {
            style = 32;
        } else if (this.modelItem.getType() == ItemType.RADIO) {
            style = 16;
        }
        ToolItem item = null;
        item = index >= 0 ? new ToolItem(parent, style, index) : new ToolItem(parent, style);
        item.setData((Object)this);
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        item.addListener(14, this.getItemListener());
        this.widget = item;
        this.modelItem.setWidget((Object)this.widget);
        this.widget.setData("modelElement", (Object)this.modelItem);
        ToolItemUpdater updater = this.getUpdater();
        if (updater != null) {
            updater.registerItem(this);
        }
        this.update(null);
        this.postToolbarFill();
    }

    protected void postToolbarFill() {
    }

    protected IEclipseContext getContextForParent(MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    protected IEclipseContext getContext(MUIElement part) {
        if (part instanceof MContext) {
            return ((MContext)part).getContext();
        }
        return this.getContextForParent(part);
    }

    public Widget getWidget() {
        return this.widget;
    }

    protected Menu getMenu(final MMenu mmenu, ToolItem toolItem) {
        Object obj = mmenu.getWidget();
        if (obj instanceof Menu && !((Menu)obj).isDisposed()) {
            return (Menu)obj;
        }
        if (RenderedElementUtil.isRenderedMenu((MUIElement)mmenu)) {
            IMenuCreator creator;
            Menu menu;
            obj = RenderedElementUtil.getContributionManager((MUIElement)mmenu);
            if (obj instanceof IContextFunction) {
                IEclipseContext lclContext = this.getContext((MUIElement)mmenu);
                obj = ((IContextFunction)obj).compute(lclContext, null);
                RenderedElementUtil.setContributionManager((MUIElement)mmenu, (Object)obj);
            }
            if (obj instanceof IMenuCreator && (menu = (creator = (IMenuCreator)obj).getMenu((Control)toolItem.getParent().getShell())) != null) {
                toolItem.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (menu != null && !menu.isDisposed()) {
                            creator.dispose();
                            mmenu.setWidget(null);
                        }
                    }
                });
                menu.setData("modelElement", (Object)menu);
                return menu;
            }
        } else {
            IEclipseContext lclContext = this.getContext((MUIElement)this.getModel());
            IPresentationEngine engine = (IPresentationEngine)lclContext.get(IPresentationEngine.class);
            obj = engine.createGui((MUIElement)mmenu, (Object)toolItem.getParent(), lclContext);
            if (obj instanceof Menu) {
                return (Menu)obj;
            }
            if (this.logger != null) {
                this.logger.debug("Rendering returned " + obj);
            }
        }
        return null;
    }

    protected boolean dropdownEvent(Event event) {
        if (event.detail == 4 && this.modelItem instanceof MToolItem) {
            ToolItem ti = (ToolItem)event.widget;
            MMenu mmenu = ((MToolItem)this.modelItem).getMenu();
            if (mmenu == null) {
                return false;
            }
            Menu menu = this.getMenu(mmenu, ti);
            if (menu == null || menu.isDisposed()) {
                return true;
            }
            Rectangle itemBounds = ti.getBounds();
            Point displayAt = ti.getParent().toDisplay(itemBounds.x, itemBounds.y + itemBounds.height);
            menu.setLocation(displayAt);
            menu.setVisible(true);
            Display display = menu.getDisplay();
            while (!menu.isDisposed() && menu.isVisible()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return true;
        }
        return false;
    }

    protected void handleWidgetSelection(Event event) {
        if (this.widget != null && !this.widget.isDisposed()) {
            if (this.dropdownEvent(event)) {
                return;
            }
            if (this.modelItem.getType() == ItemType.CHECK || this.modelItem.getType() == ItemType.RADIO) {
                boolean selection = false;
                if (this.widget instanceof MenuItem) {
                    selection = ((MenuItem)this.widget).getSelection();
                } else if (this.widget instanceof ToolItem) {
                    selection = ((ToolItem)this.widget).getSelection();
                }
                this.modelItem.setSelected(selection);
            }
            if (this.canExecuteItem(event)) {
                this.executeItem(event);
            }
        }
    }

    protected abstract void executeItem(Event var1);

    protected abstract boolean canExecuteItem(Event var1);

    protected Listener getItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            AbstractContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: 
                        case 14: {
                            if (event.widget == null) break;
                            AbstractContributionItem.this.handleWidgetSelection(event);
                            break;
                        }
                        case 28: {
                            AbstractContributionItem.this.handleHelpRequest();
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    protected void handleHelpRequest() {
        if (this.helpService == null) {
            return;
        }
        String helpContextId = (String)this.getModel().getPersistedState().get("HelpContextId");
        if (helpContextId != null) {
            this.helpService.displayHelp(helpContextId);
        }
    }

    protected abstract void handleWidgetDispose(Event var1);

    protected void updateVisible() {
        this.setVisible(this.modelItem.isVisible());
        IContributionManager parent = this.getParent();
        if (parent != null) {
            parent.markDirty();
        }
    }

    private ISafeRunnable getUpdateRunner() {
        if (this.updateRunner == null) {
            this.updateRunner = new ISafeRunnable(){

                public void run() throws Exception {
                    boolean shouldEnable = AbstractContributionItem.this.canExecuteItem(null);
                    if (shouldEnable != AbstractContributionItem.this.modelItem.isEnabled()) {
                        AbstractContributionItem.this.modelItem.setEnabled(shouldEnable);
                        AbstractContributionItem.this.update();
                    }
                }

                public void handleException(Throwable exception) {
                    if (!AbstractContributionItem.this.logged) {
                        AbstractContributionItem.this.logged = true;
                        if (AbstractContributionItem.this.logger != null) {
                            AbstractContributionItem.this.logger.error(exception, "Internal error during tool item enablement updating, this is only logged once per tool item.");
                        }
                    }
                }
            };
        }
        return this.updateRunner;
    }

    protected ToolItemUpdater getUpdater() {
        Object obj;
        if (this.modelItem != null && (obj = this.modelItem.getRenderer()) instanceof ToolBarManagerRenderer) {
            return ((ToolBarManagerRenderer)((Object)obj)).getUpdater();
        }
        return null;
    }

    protected void updateItemEnablement() {
        if (!(this.modelItem.getWidget() instanceof ToolItem)) {
            return;
        }
        ToolItem widget = (ToolItem)this.modelItem.getWidget();
        if (widget == null || widget.isDisposed()) {
            return;
        }
        SafeRunner.run((ISafeRunnable)this.getUpdateRunner());
    }
}

