/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity2VirtualSupersetTypeRelationship;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.model.rule.VirtualEntityRule;

public class VirtualSupersetType2VirtualSupersetRelationship
extends AbstractConnectionModel {
    private VirtualSuperset superset;
    private VirtualSupersetType type;
    private List<Entity2VirtualSupersetTypeRelationship> subset2typeRelationshipList;

    public VirtualSupersetType2VirtualSupersetRelationship() {
    }

    public VirtualSupersetType2VirtualSupersetRelationship(String virtualSupersetName, List<AbstractEntityModel> subsets) {
        this.setSource(new VirtualSupersetType());
        this.setTarget(VirtualEntityRule.createVirtualSuperset(virtualSupersetName));
        this.subset2typeRelationshipList = new ArrayList<Entity2VirtualSupersetTypeRelationship>();
        for (AbstractEntityModel s : subsets) {
            Entity2VirtualSupersetTypeRelationship r = new Entity2VirtualSupersetTypeRelationship(s, (ConnectableElement)this.type);
            this.subset2typeRelationshipList.add(r);
        }
    }

    @Override
    public void connect() {
        super.connect();
        this.connectSubsetList();
        Diagram diagram = this.getDiagram();
        diagram.addChild(this.superset);
        diagram.addChild(this.type);
    }

    private Diagram getDiagram() {
        return ((AbstractEntityModel)this.subset2typeRelationshipList.get(0).getSource()).getDiagram();
    }

    private void connectSubsetList() {
        for (Entity2VirtualSupersetTypeRelationship r : this.subset2typeRelationshipList) {
            r.connect();
        }
    }

    @Override
    public void disconnect() {
        Diagram diagram = this.getDiagram();
        diagram.removeChild(this.type);
        diagram.removeChild(this.superset);
        this.disconnectSubsetList();
        super.disconnect();
    }

    private void disconnectSubsetList() {
        for (Entity2VirtualSupersetTypeRelationship r : this.subset2typeRelationshipList) {
            r.disconnect();
        }
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    @Override
    public String getSourceName() {
        return this.getTarget().getName();
    }

    @Override
    public String getTargetName() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        VirtualSupersetType type = (VirtualSupersetType)this.getSource();
        for (AbstractEntityModel m : type.getSubsetList()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(m.getName());
        }
        return builder.toString();
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public VirtualSuperset getSuperset() {
        return this.superset;
    }

    public VirtualSupersetType getType() {
        return this.type;
    }

    private List<AbstractEntityModel> getSubsetList() {
        ArrayList<AbstractEntityModel> list = new ArrayList<AbstractEntityModel>();
        for (Entity2VirtualSupersetTypeRelationship r : this.subset2typeRelationshipList) {
            list.add((AbstractEntityModel)r.getSource());
        }
        return list;
    }

    public void reconnect(List<AbstractEntityModel> subsets) {
        List<AbstractEntityModel> currentSubsetList = this.getSubsetList();
        ArrayList<Entity2VirtualSupersetTypeRelationship> newSubsetList = new ArrayList<Entity2VirtualSupersetTypeRelationship>();
        for (AbstractEntityModel s : subsets) {
            int index = currentSubsetList.indexOf(s);
            if (index > 0) {
                newSubsetList.add(this.subset2typeRelationshipList.get(index));
                continue;
            }
            newSubsetList.add(new Entity2VirtualSupersetTypeRelationship(s, (ConnectableElement)this.type));
        }
        this.disconnectSubsetList();
        this.subset2typeRelationshipList = newSubsetList;
        this.connectSubsetList();
    }

    public List<Entity2VirtualSupersetTypeRelationship> getSubset2typeRelationshipList() {
        return this.subset2typeRelationshipList;
    }

    public void setSubset2typeRelationshipList(List<Entity2VirtualSupersetTypeRelationship> subset2typeRelationshipList) {
        this.subset2typeRelationshipList = subset2typeRelationshipList;
    }

    @Override
    public void setSource(ConnectableElement source) {
        super.setSource(source);
        this.type = (VirtualSupersetType)source;
    }

    @Override
    public void setTarget(ConnectableElement target) {
        super.setTarget(target);
        this.superset = (VirtualSuperset)target;
    }
}

