/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.action.AbstractEntitySelectionAction;
import jp.sourceforge.tmdmaker.editpart.EntityEditPart;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.Cardinality;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Header2DetailRelationship;
import jp.sourceforge.tmdmaker.model.MultivalueAndAggregator;
import jp.sourceforge.tmdmaker.model.MultivalueAndSuperset;
import jp.sourceforge.tmdmaker.model.rule.EntityTypeRule;
import jp.sourceforge.tmdmaker.model.rule.RelationshipRule;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ConnectionCreateCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ConnectionDeleteCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ConstraintAdjusterCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.RelationshipConnectionCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IWorkbenchPart;

public class MultivalueAndCreateAction
extends AbstractEntitySelectionAction {
    public static final String ID = "_MA";

    public MultivalueAndCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.CreateMultivalueAnd);
        this.setId(ID);
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() == 1) {
            Object selection = this.getSelectedObjects().get(0);
            return selection instanceof EntityEditPart;
        }
        return false;
    }

    public void run() {
        AbstractEntityModel model = this.getModel();
        Header2DetailRelationship relationship = new Header2DetailRelationship(model);
        Detail detail = relationship.getDetail();
        MultivalueAndAggregator aggregator = relationship.getAggregator();
        MultivalueAndSuperset superset = relationship.getMultivalueAndSuperset();
        CompoundCommand ccommand = new CompoundCommand();
        ccommand.add((Command)new RelationshipConnectionCommand((AbstractConnectionModel)relationship));
        ccommand.add((Command)new ConstraintAdjusterCommand(model, (ConnectableElement)detail, 100, 0));
        ccommand.add((Command)new ConstraintAdjusterCommand(model, (ConnectableElement)superset, 64, -80));
        ccommand.add((Command)new ConstraintAdjusterCommand(model, (ConnectableElement)aggregator, 75, -30));
        if (EntityTypeRule.isEvent((AbstractEntityModel)model)) {
            for (AbstractConnectionModel con : model.getModelTargetConnections()) {
                AbstractRelationship relation;
                if (!(con instanceof AbstractRelationship) || !(relation = (AbstractRelationship)con).isMultiValue()) continue;
                AbstractEntityModel source = relation.getSource();
                ConnectionDeleteCommand command2 = new ConnectionDeleteCommand((AbstractConnectionModel)relation);
                ccommand.add((Command)command2);
                AbstractRelationship newRelation = RelationshipRule.createRelationship((AbstractEntityModel)source, (AbstractEntityModel)detail);
                newRelation.setTargetCardinality(Cardinality.MANY);
                ConnectionCreateCommand command3 = new ConnectionCreateCommand((AbstractConnectionModel)newRelation, (ConnectableElement)source, (ConnectableElement)detail);
                ccommand.add((Command)command3);
            }
        }
        this.execute(ccommand.unwrap());
    }
}

