/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.Cardinality;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RelationshipEditDialog
extends Dialog {
    private static final String NOT_MATCH = Messages.NoRelationship;
    private Cardinality sourceCardinality = Cardinality.ONE;
    private Cardinality targetCardinality = Cardinality.ONE;
    private boolean sourceNoInstance;
    private boolean targetNoInstance;
    private String sourceName;
    private String targetName;
    private Combo sourceCardinalityCombo;
    private Combo targetCardinalityCombo;
    private Button sourceCardinalityCheck;
    private Button targetCardinalityCheck;

    public RelationshipEditDialog(Shell parentShell, String sourceName, String targetName) {
        super(parentShell);
        this.sourceName = sourceName;
        this.targetName = targetName;
    }

    public RelationshipEditDialog(Shell parentShell, String sourceName, String targetName, Cardinality sourceCardinaliry, Cardinality targetCardinality, boolean sourceNoInstance, boolean targetNoInstance) {
        this(parentShell, sourceName, targetName);
        this.sourceCardinality = sourceCardinaliry;
        this.targetCardinality = targetCardinality;
        this.sourceNoInstance = sourceNoInstance;
        this.targetNoInstance = targetNoInstance;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.EditRelationship);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(this.sourceName);
        this.sourceCardinalityCombo = new Combo(composite, 8);
        this.sourceCardinalityCombo.add(Cardinality.ONE.getLabel());
        this.sourceCardinalityCombo.add(Cardinality.MANY.getLabel());
        this.sourceCardinalityCombo.select(this.sourceCardinalityCombo.indexOf(this.sourceCardinality.getLabel()));
        label = new Label(composite, 0);
        label.setText(":");
        this.targetCardinalityCombo = new Combo(composite, 8);
        this.targetCardinalityCombo.add(Cardinality.ONE.getLabel());
        this.targetCardinalityCombo.add(Cardinality.MANY.getLabel());
        this.targetCardinalityCombo.select(this.targetCardinalityCombo.indexOf(this.targetCardinality.getLabel()));
        label = new Label(composite, 0);
        label.setText(this.targetName);
        label = new Label(composite, 0);
        label.setText(NOT_MATCH);
        this.sourceCardinalityCheck = new Button(composite, 32);
        this.sourceCardinalityCheck.setSelection(this.sourceNoInstance);
        this.sourceCardinalityCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button bBut = (Button)e.widget;
                if (bBut.getSelection()) {
                    RelationshipEditDialog.this.sourceNoInstance = true;
                } else {
                    RelationshipEditDialog.this.sourceNoInstance = false;
                }
            }
        });
        label = new Label(composite, 0);
        label.setText("");
        label = new Label(composite, 0);
        label.setText(NOT_MATCH);
        this.targetCardinalityCheck = new Button(composite, 32);
        this.targetCardinalityCheck.setSelection(this.targetNoInstance);
        this.targetCardinalityCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button bBut = (Button)e.widget;
                if (bBut.getSelection()) {
                    RelationshipEditDialog.this.targetNoInstance = true;
                } else {
                    RelationshipEditDialog.this.targetNoInstance = false;
                }
            }
        });
        composite.pack();
        return composite;
    }

    protected void okPressed() {
        this.sourceCardinality = this.getSelectedCardinality(this.sourceCardinalityCombo);
        this.targetCardinality = this.getSelectedCardinality(this.targetCardinalityCombo);
        super.okPressed();
    }

    private Cardinality getSelectedCardinality(Combo combo) {
        String selectedLabel = combo.getItem(combo.getSelectionIndex());
        if (selectedLabel.equals(Cardinality.ONE.getLabel())) {
            return Cardinality.ONE;
        }
        return Cardinality.MANY;
    }

    public Cardinality getSourceCardinality() {
        return this.sourceCardinality;
    }

    public Cardinality getTargetCardinality() {
        return this.targetCardinality;
    }

    public boolean isSourceNoInstance() {
        return this.sourceNoInstance;
    }

    public boolean isTargetNoInstance() {
        return this.targetNoInstance;
    }
}

