/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.figure;

import java.util.List;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class EntityFigure
extends Figure {
    private Label name = new Label();
    private Label type = new Label();
    private EntityTitleCompartmentFigure titleCompartmentFigure = new EntityTitleCompartmentFigure();
    private EntityLayoutCompartmentFigure compartmentFigure = new EntityLayoutCompartmentFigure();
    private CompartmentFigure identifierCompartmentFigure = new CompartmentFigure();
    private CompartmentFigure attributeCompartmentFigure = new CompartmentFigure();

    public EntityFigure() {
        this(false);
    }

    public EntityFigure(boolean notImplement) {
        ToolbarLayout layout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new EntityFigureBorder(notImplement));
        this.setOpaque(true);
        this.titleCompartmentFigure.setEntityName((Figure)this.name);
        this.titleCompartmentFigure.setEntityType((Figure)this.type);
        this.add((IFigure)this.titleCompartmentFigure);
        this.add((IFigure)this.compartmentFigure);
        this.attributeCompartmentFigure.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        this.compartmentFigure.add((IFigure)this.identifierCompartmentFigure);
        this.compartmentFigure.add((IFigure)this.attributeCompartmentFigure);
    }

    public CompartmentFigure getAttributeCompartmentFigure() {
        return this.attributeCompartmentFigure;
    }

    public void setEntityName(String entityName) {
        this.name.setText(entityName);
    }

    public void setEntityType(String entityType) {
        this.type.setText(entityType);
    }

    private Label createAttributeLabel(String name) {
        Label tmp = new Label(name);
        tmp.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        tmp.setLabelAlignment(1);
        return tmp;
    }

    public void setIdentifier(String identifier) {
        this.identifierCompartmentFigure.add((IFigure)this.createAttributeLabel(identifier));
    }

    public void addRelationship(String relationship) {
        this.identifierCompartmentFigure.add((IFigure)this.createAttributeLabel(String.valueOf(relationship) + "(R)"));
    }

    public void addRelationship(List<String> relationship) {
        for (String r : relationship) {
            this.addRelationship(r);
        }
    }

    public void removeAllRelationship() {
        this.identifierCompartmentFigure.removeAll();
    }

    public void addAttribute(String attribute) {
        this.attributeCompartmentFigure.add((IFigure)this.createAttributeLabel(attribute));
    }

    public void removeAllAttributes() {
        this.attributeCompartmentFigure.removeAll();
    }

    public void setNotImplement(boolean notImplement) {
        this.setBorder((Border)new EntityFigureBorder(notImplement));
    }

    public void setColor(Color foregroundColor, Color backgroundColor) {
        this.setForegroundColor(foregroundColor);
        this.setBackgroundColor(backgroundColor);
    }

    private static class CompartmentFigure
    extends Figure {
        public CompartmentFigure() {
            ToolbarLayout layout = new ToolbarLayout();
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(true);
            layout.setSpacing(0);
            this.setLayoutManager((LayoutManager)layout);
        }
    }

    private class EntityFigureBorder
    extends LineBorder {
        private boolean notImplement;

        public EntityFigureBorder(boolean notImplement) {
            this.notImplement = notImplement;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            boolean attributeNotEmpty;
            super.paint(figure, graphics, insets);
            boolean identifierNotEmpty = EntityFigure.this.identifierCompartmentFigure.getChildren().size() > 0;
            boolean bl = attributeNotEmpty = EntityFigure.this.attributeCompartmentFigure.getChildren().size() > 0;
            if (identifierNotEmpty || attributeNotEmpty) {
                Rectangle rect1 = EntityFigure.this.titleCompartmentFigure.getBounds();
                Rectangle rect2 = null;
                Point p = null;
                Point p2 = null;
                if (identifierNotEmpty) {
                    rect2 = EntityFigure.this.identifierCompartmentFigure.getBounds();
                    p = tempRect.getTopLeft().getCopy();
                    p.x = p.x + rect2.width + 2;
                    p.y = p.y + rect1.height + 2;
                    p2 = tempRect.getBottomLeft().getCopy();
                    p2.x = p2.x + rect2.width + 2;
                } else {
                    rect2 = EntityFigure.this.attributeCompartmentFigure.getBounds();
                    p = tempRect.getTopLeft().getCopy();
                    p.x += 2;
                    p.y = p.y + rect1.height + 2;
                    p2 = tempRect.getBottomLeft().getCopy();
                    p2.x += 2;
                }
                graphics.drawLine(p, p2);
            }
            if (this.notImplement) {
                graphics.drawLine(tempRect.getTopLeft(), tempRect.getBottomRight());
                graphics.drawLine(tempRect.getBottomLeft(), tempRect.getTopRight());
            }
        }
    }

    private static class EntityLayoutCompartmentFigure
    extends Figure {
        public EntityLayoutCompartmentFigure() {
            ToolbarLayout layout = new ToolbarLayout(true);
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(true);
            layout.setSpacing(0);
            this.setLayoutManager((LayoutManager)layout);
            this.setBorder((Border)new EntityLayoutCompartmentFigureBorder());
        }
    }

    private static class EntityLayoutCompartmentFigureBorder
    extends AbstractBorder {
        private EntityLayoutCompartmentFigureBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(0, 1, 0, 1);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            if (((IFigure)figure.getChildren().get(0)).getChildren().size() > 0 || ((IFigure)figure.getChildren().get(1)).getChildren().size() > 0) {
                graphics.drawLine(EntityLayoutCompartmentFigureBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTopLeft(), tempRect.getTopRight());
            }
        }
    }

    private static class EntityTitleCompartmentFigure
    extends Figure {
        public EntityTitleCompartmentFigure() {
            this.setLayoutManager((LayoutManager)new BorderLayout());
            this.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        }

        public void setEntityName(Figure name) {
            this.add((IFigure)name);
            this.getLayoutManager().setConstraint((IFigure)name, (Object)BorderLayout.CENTER);
        }

        public void setEntityType(Figure type) {
            this.add((IFigure)type);
            this.getLayoutManager().setConstraint((IFigure)type, (Object)BorderLayout.RIGHT);
        }
    }
}

