/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.actions;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Header2DetailRelationship;
import jp.sourceforge.tmdmaker.ui.actions.AbstractEntitySelectionAction;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class MultivalueAndSupersetHideAction
extends AbstractEntitySelectionAction {
    public static final String ID = "_MVA_SE_HIDE";

    public MultivalueAndSupersetHideAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.HideMultivalueAndSuperset);
        this.setId(ID);
    }

    @Override
    protected boolean calculateEnabled() {
        if (super.calculateEnabled()) {
            AbstractEntityModel entity = this.getModel();
            if (!entity.isHeaderDetail()) {
                return false;
            }
            Header2DetailRelationship r = entity.getHeader2DetailRelationship();
            return r != null && r.isSupersetConnected();
        }
        return false;
    }

    public void run() {
        MultivalueAndSupersetHideCommand command = new MultivalueAndSupersetHideCommand(this.getModel().getHeader2DetailRelationship());
        this.execute(command);
    }

    private static class MultivalueAndSupersetHideCommand
    extends Command {
        private Header2DetailRelationship relationship;

        public MultivalueAndSupersetHideCommand(Header2DetailRelationship relationship) {
            this.relationship = relationship;
        }

        public void execute() {
            this.relationship.disconnectSuperset();
        }

        public void undo() {
            this.relationship.connectSuperset();
        }
    }
}

