/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker;

import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.extension.GeneratorFactory;
import jp.sourceforge.tmdmaker.extension.PluginExtensionPointFactory;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.generate.Generator;
import jp.sourceforge.tmdmaker.model.importer.FileImporter;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMDContextMenuProvider
extends ContextMenuProvider {
    private ActionRegistry actionRegistry;
    private static Logger logger = LoggerFactory.getLogger(TMDContextMenuProvider.class);

    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public void setActionRegistry(ActionRegistry actionRegistry) {
        this.actionRegistry = actionRegistry;
    }

    public TMDContextMenuProvider(EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        this.setActionRegistry(registry);
    }

    public void buildContextMenu(IMenuManager menu) {
        block13: {
            ActionRegistry registry = this.getActionRegistry();
            EditPartViewer viewer = this.getViewer();
            List list = viewer.getSelectedEditParts();
            if (list == null) break block13;
            for (EditPart e : list) {
                logger.debug("editpart:" + e.getModel().getClass().getName());
            }
            if (list.size() > 1) {
                menu.add(registry.getAction((Object)"_VS"));
                menu.add((IContributionItem)new Separator("generate"));
                menu.add(registry.getAction((Object)"DiagramImageGenerateAction"));
                for (Generator generator : GeneratorFactory.getGenerators()) {
                    menu.add(registry.getAction((Object)generator.getClass().getName()));
                }
            } else if (list.size() == 1) {
                if (((EditPart)list.get(0)).getModel() instanceof AbstractEntityModel) {
                    menu.add(registry.getAction((Object)"_OPEN"));
                    menu.add(registry.getAction((Object)ActionFactory.DELETE.getId()));
                    menu.add(registry.getAction((Object)"_SUBSET"));
                    MenuManager multivalueMenu = new MenuManager(Messages.Multivalue);
                    multivalueMenu.add(registry.getAction((Object)"_MO"));
                    multivalueMenu.add(registry.getAction((Object)"_MA"));
                    multivalueMenu.add(registry.getAction((Object)"_MVA_SE_HIDE"));
                    multivalueMenu.add(registry.getAction((Object)"_MVA_SE_SHOW"));
                    menu.add((IContributionItem)multivalueMenu);
                    MenuManager tmdashMenu = new MenuManager(Messages.VirtualConcept);
                    tmdashMenu.add(registry.getAction((Object)"_VE"));
                    tmdashMenu.add(registry.getAction((Object)"_VS"));
                    menu.add((IContributionItem)tmdashMenu);
                    menu.add((IContributionItem)new Separator("implement"));
                    menu.add(registry.getAction((Object)"ImplementInfoEditAction"));
                    menu.add(registry.getAction((Object)"CommonAtributeSettingAction"));
                    menu.add((IContributionItem)new Separator("generate"));
                    for (Generator generator : GeneratorFactory.getGenerators()) {
                        menu.add(registry.getAction((Object)generator.getClass().getName()));
                    }
                } else if (((EditPart)list.get(0)).getModel() instanceof SubsetType) {
                    menu.add(registry.getAction((Object)"_SUBSETTYPE"));
                } else {
                    menu.add(registry.getAction((Object)"_OPEN"));
                    menu.add(registry.getAction((Object)ActionFactory.DELETE.getId()));
                }
            } else {
                menu.add(registry.getAction((Object)"DatabaseSelectAction"));
                menu.add(registry.getAction((Object)"_VS"));
                menu.add((IContributionItem)new Separator("generate"));
                menu.add(registry.getAction((Object)"DiagramImageGenerateAction"));
                for (Generator generator : GeneratorFactory.getGenerators()) {
                    menu.add(registry.getAction((Object)generator.getClass().getName()));
                }
                menu.add((IContributionItem)new Separator("importer"));
                PluginExtensionPointFactory fileImportFactory = new PluginExtensionPointFactory("tmdmaker.importers");
                for (FileImporter importer : fileImportFactory.getInstances()) {
                    menu.add(registry.getAction((Object)importer.getClass().getName()));
                }
            }
        }
    }
}

