/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.actions;

import java.io.File;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.imagegenerator.Draw2dToImageConverter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DiagramImageGenerateAction
extends Action {
    private GraphicalViewer viewer;
    private IWorkbenchPart part;
    private Draw2dToImageConverter converter;
    public static final String ID = "DiagramImageGenerateAction";

    public DiagramImageGenerateAction(GraphicalViewer viewer, IWorkbenchPart part) {
        this.viewer = viewer;
        this.part = part;
        this.setText(Messages.GenerateImage);
        this.setId(ID);
        this.converter = new Draw2dToImageConverter();
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.viewer.getControl().getShell(), 8192);
        IFile editfile = TMDPlugin.getEditFile(this.part);
        dialog.setFileName(editfile.getLocation().removeFileExtension().lastSegment());
        String path = editfile.getLocation().removeLastSegments(1).toOSString();
        String separator = File.separator;
        if (!path.endsWith(separator)) {
            path = String.valueOf(path) + separator;
        }
        dialog.setFilterPath(path);
        String[] extensions = this.converter.getExtensions();
        dialog.setFilterExtensions(extensions);
        String file = dialog.open();
        if (file != null) {
            final StringBuffer filePath = new StringBuffer(file);
            final String extension = extensions[dialog.getFilterIndex()];
            if (!file.endsWith(extension)) {
                filePath.append(".");
                filePath.append(extension);
            }
            FreeformGraphicalRootEditPart rootEditPart = (FreeformGraphicalRootEditPart)this.getViewer().getRootEditPart();
            final IFigure figure = rootEditPart.getLayer((Object)"Printable Layers");
            try {
                new ProgressMonitorDialog(this.getViewer().getControl().getShell()).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.Generating, 1);
                        DiagramImageGenerateAction.this.converter.execute(figure, filePath.toString(), extension);
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                TMDPlugin.showErrorDialog(e);
            }
            TMDPlugin.showMessageDialog(String.valueOf(this.getText()) + Messages.Completion);
            try {
                TMDPlugin.refreshGenerateResource(filePath.toString());
            }
            catch (Exception e) {
                TMDPlugin.showErrorDialog(e);
            }
        }
    }

    protected GraphicalViewer getViewer() {
        return this.viewer;
    }
}

