/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.draw2d.figure.node;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;

public class SubsetTypeFigure
extends Figure {
    private boolean vertical = false;
    private static final int LINE_WIDTH = 1;

    public SubsetTypeFigure() {
        this(true, false);
    }

    public SubsetTypeFigure(boolean sameType, boolean vertical) {
        this.setOpaque(false);
        this.vertical = vertical;
        this.setBorder((Border)new SubsetBorder(sameType, this.vertical));
    }

    public void setSameType(boolean sameType) {
        if (sameType) {
            if (this.vertical) {
                this.setSize(5, 30);
            } else {
                this.setSize(30, 5);
            }
        } else if (this.vertical) {
            this.setSize(10, 30);
        } else {
            this.setSize(30, 10);
        }
        ((SubsetBorder)this.getBorder()).setSameType(sameType);
        this.repaint();
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
        ((SubsetBorder)this.getBorder()).setVertical(vertical);
        this.repaint();
    }

    public boolean canAutoSize() {
        return false;
    }

    private static class SubsetBorder
    extends AbstractBorder {
        private int width = 1;
        private boolean sameType = true;
        private boolean vertical = false;

        public SubsetBorder(boolean sameType, boolean vertical) {
            this.sameType = sameType;
            this.vertical = vertical;
        }

        public int getWidth() {
            return this.width;
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(this.getWidth());
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            if (this.sameType) {
                this.paintSubsetSameType(figure, graphics, insets);
            } else {
                this.paintSubsetDifferenceType(figure, graphics, insets);
            }
        }

        private void paintSubsetSameType(IFigure figure, Graphics graphics, Insets insets) {
            tempRect.setBounds(SubsetBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            if (this.getWidth() % 2 != 0) {
                --SubsetBorder.tempRect.width;
                --SubsetBorder.tempRect.height;
            }
            tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
            graphics.setLineWidth(this.getWidth());
            if (this.vertical) {
                graphics.drawLine(tempRect.getTopLeft(), tempRect.getBottomLeft());
                graphics.drawLine(tempRect.getTopRight(), tempRect.getBottomRight());
                graphics.drawLine(SubsetBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getLeft(), tempRect.getCenter());
            } else {
                graphics.drawLine(tempRect.getTopLeft(), tempRect.getTopRight());
                graphics.drawLine(tempRect.getBottomLeft(), tempRect.getBottomRight());
                graphics.drawLine(SubsetBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTop(), tempRect.getCenter());
            }
        }

        private void paintSubsetDifferenceType(IFigure figure, Graphics graphics, Insets insets) {
            tempRect.setBounds(SubsetBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            graphics.drawLine(tempRect.getTopLeft(), tempRect.getBottomRight());
            graphics.drawLine(tempRect.getBottomLeft(), tempRect.getTopRight());
        }

        public void setSameType(boolean sameType) {
            this.sameType = sameType;
        }

        public void setVertical(boolean vertical) {
            this.vertical = vertical;
        }
    }
}

