/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.serializer.handler.patch;

import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity2SubsetTypeRelationship;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.serializer.handler.patch.AbstractSerializerHandler;
import jp.sourceforge.tmdmaker.serializer.handler.patch.AnchorConstraintMigrator;

public class Patch023SerializerHandler
extends AbstractSerializerHandler {
    @Override
    public Diagram handleAfterDeserialize(Diagram in) {
        this.logger.info("handleAfterDeserialize");
        if (this.versionUnderEqual(in, 0, 2, 2)) {
            this.logger.info("apply patch 0.2.3");
            for (ModelElement o : in.getChildren()) {
                if (!(o instanceof AbstractEntityModel)) continue;
                AbstractEntityModel model = (AbstractEntityModel)o;
                this.convert(model);
            }
        }
        return in;
    }

    private void convert(AbstractEntityModel model) {
        this.convertRelatedRelationships(model.getModelSourceConnections());
        this.convertRelatedRelationships(model.getModelTargetConnections());
    }

    private void convertRelatedRelationships(List<AbstractConnectionModel> connections) {
        AnchorConstraintMigrator converter = new AnchorConstraintMigrator();
        for (AbstractConnectionModel c : connections) {
            if (c instanceof RelatedRelationship) {
                this.logger.debug("convertRelatedRelationships():{}", (Object)c);
                converter.convertNullLocationPoint(c);
            }
            if (!(c instanceof Entity2SubsetTypeRelationship)) continue;
            this.logger.debug("convertEntity2SubsetTypeRelationships():{}", (Object)c);
            converter.convertNullLocationPoint(c);
        }
    }
}

