/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.actions;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.ui.dialogs.DatabaseSelectDialog;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSelectAction
extends Action {
    private GraphicalViewer viewer;
    public static final String ID = "DatabaseSelectAction";
    private static Logger logger = LoggerFactory.getLogger(DatabaseSelectAction.class);

    public DatabaseSelectAction(GraphicalViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.SelectDatabase);
        this.setId(ID);
    }

    public void run() {
        logger.debug("database select");
        try {
            Diagram diagram = (Diagram)this.viewer.getContents().getModel();
            DatabaseSelectDialog dialog = new DatabaseSelectDialog(this.viewer.getControl().getShell(), diagram.getDatabaseName());
            if (dialog.open() == 0) {
                this.viewer.getEditDomain().getCommandStack().execute((Command)new DatabaseChangeCommand(diagram, dialog.getSelectedDatabaseName()));
            }
        }
        catch (Throwable t) {
            logger.warn("exception when database select.", t);
        }
    }

    private static class DatabaseChangeCommand
    extends Command {
        private Diagram diagram;
        private String oldDatabaseName;
        private String newDatabaseName;

        public DatabaseChangeCommand(Diagram diagram, String newDatabaseName) {
            this.diagram = diagram;
            this.oldDatabaseName = diagram.getDatabaseName();
            this.newDatabaseName = newDatabaseName;
        }

        public void execute() {
            this.diagram.setDatabaseName(this.newDatabaseName);
        }

        public void undo() {
            this.diagram.setDatabaseName(this.oldDatabaseName);
        }
    }
}

