/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.dialogs.components;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VirtualSupersetSettingPanel
extends Composite {
    private boolean applyAttribute = false;
    private Label virtualSupersetNameLabel = null;
    private Text virtualSupersetNameText = null;
    private Composite typeComposite = null;
    private Button sameRadioButton = null;
    private Button differentRadioButton = null;

    public VirtualSupersetSettingPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        gridData.widthHint = 80;
        gridData.grabExcessHorizontalSpace = true;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.virtualSupersetNameLabel = new Label((Composite)this, 0);
        this.virtualSupersetNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.virtualSupersetNameLabel.setText(Messages.VirtualSupersetName);
        this.virtualSupersetNameText = new Text((Composite)this, 2048);
        this.virtualSupersetNameText.setLayoutData((Object)gridData);
        this.createTypeComposite();
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(288, 62));
    }

    private void createTypeComposite() {
        GridData gridData5 = new GridData();
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.verticalAlignment = 2;
        gridData5.horizontalAlignment = 4;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 2;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        gridLayout1.verticalSpacing = 5;
        gridLayout1.marginWidth = 10;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.horizontalSpan = 3;
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.verticalAlignment = 2;
        this.typeComposite = new Composite((Composite)this, 0);
        this.typeComposite.setLayoutData((Object)gridData1);
        this.typeComposite.setLayout((Layout)gridLayout1);
        this.sameRadioButton = new Button(this.typeComposite, 16);
        this.sameRadioButton.setText(Messages.ApplyAttribute);
        this.sameRadioButton.setLayoutData((Object)gridData2);
        this.sameRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VirtualSupersetSettingPanel.this.applyAttribute = true;
            }
        });
        this.differentRadioButton = new Button(this.typeComposite, 16);
        this.differentRadioButton.setText(Messages.ApplyEntity);
        this.differentRadioButton.setLayoutData((Object)gridData5);
        this.differentRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VirtualSupersetSettingPanel.this.applyAttribute = false;
            }
        });
    }

    public void initializeValue(VirtualSuperset superset) {
        if (superset != null) {
            if (superset.getName() != null) {
                this.virtualSupersetNameText.setText(superset.getName());
            }
            this.applyAttribute = superset.getVirtualSupersetType().isApplyAttribute();
            this.sameRadioButton.setSelection(this.applyAttribute);
            this.differentRadioButton.setSelection(!this.applyAttribute);
        } else {
            this.applyAttribute = true;
            this.sameRadioButton.setSelection(this.applyAttribute);
        }
    }

    public String getVirtualSupersetName() {
        return this.virtualSupersetNameText.getText();
    }

    public boolean isApplyAttributeSelected() {
        return this.applyAttribute;
    }

    public void addNameModifyListener(ModifyListener listener) {
        this.virtualSupersetNameText.addModifyListener(listener);
    }

    public void removeNameModifyListener(ModifyListener listener) {
        this.virtualSupersetNameText.removeModifyListener(listener);
    }
}

