/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.internal;

import java.security.InvalidParameterException;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.factory.RenderedImageKey;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractRenderedImage
implements RenderedImage {
    private byte[] buffer = null;
    private RenderedImageKey key = null;
    private Image img = null;

    public AbstractRenderedImage(byte[] buff, RenderedImageKey key) {
        if (buff == null || key == null) {
            throw new InvalidParameterException();
        }
        this.buffer = buff;
        this.key = key;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public RenderedImageKey getKey() {
        return new RenderedImageKey(this.key, this.key.getChecksum(), this.key.getExtraData(), this.key.getURLString());
    }

    protected void finalize() throws Throwable {
        if (this.img != null) {
            this.img.dispose();
            this.img = null;
        }
        this.key = null;
        super.finalize();
    }

    @Override
    public RenderInfo getRenderInfo() {
        return this.getKey();
    }

    @Override
    public RenderedImage getNewRenderedImage(RenderInfo info) {
        if (!this.getRenderInfo().equals(info)) {
            RenderedImage rndImg = RenderedImageFactory.getRelatedInstance(this, info);
            if (rndImg != null) {
                return rndImg;
            }
            return RenderedImageFactory.getInstance(this.getBuffer(), info);
        }
        return this;
    }

    @Override
    public boolean isRendered() {
        return this.img != null;
    }

    @Override
    public final Image getSWTImage() {
        if (this.img != null) {
            return this.img;
        }
        Image image = this.renderImage();
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
        }
        this.img = image;
        return this.img;
    }

    protected abstract Image renderImage();

    public Object getAdapter(Class adapter) {
        if (adapter.equals(Image.class)) {
            return this.getSWTImage();
        }
        return null;
    }
}

