/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.Iterator;
import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.CombinationTableType;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;

public class CombinationTable
extends AbstractEntityModel {
    public static final String COMBINATION_TABLE_SUFFIX = ".\u5bfe\u7167\u8868";
    private CombinationTableType combinationTableType = CombinationTableType.L_TRUTH;

    protected CombinationTable() {
        this.setEntityType(EntityType.RESOURCE);
    }

    @Override
    public ReusedIdentifier createReusedIdentifier() {
        ReusedIdentifier returnValue = new ReusedIdentifier(this.keyModels.getSurrogateKey());
        this.checkDuplicateTargetReusedIdentifiers();
        for (Map.Entry rk : this.reusedIdentifiers.entrySet()) {
            returnValue.addAll(((ReusedIdentifier)rk.getValue()).getIdentifiers());
        }
        return returnValue;
    }

    @Override
    public Map<AbstractEntityModel, ReusedIdentifier> getReusedIdentifiers() {
        this.checkDuplicateTargetReusedIdentifiers();
        return super.getReusedIdentifiers();
    }

    private Map.Entry<AbstractEntityModel, ReusedIdentifier> getSource() {
        Iterator<Map.Entry<AbstractEntityModel, ReusedIdentifier>> it = super.getReusedIdentifiers().entrySet().iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    private Map.Entry<AbstractEntityModel, ReusedIdentifier> getTarget() {
        Iterator<Map.Entry<AbstractEntityModel, ReusedIdentifier>> it = super.getReusedIdentifiers().entrySet().iterator();
        if (!it.hasNext()) {
            return null;
        }
        it.next();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    private void checkDuplicateTargetReusedIdentifiers() {
        Map.Entry<AbstractEntityModel, ReusedIdentifier> source = this.getSource();
        Map.Entry<AbstractEntityModel, ReusedIdentifier> target = this.getTarget();
        if (source == null || target == null) {
            return;
        }
        for (IdentifierRef i : target.getValue().getIdentifiers()) {
            i.setDuplicate(this.containIdentifier(source.getValue(), i));
        }
    }

    private boolean containIdentifier(ReusedIdentifier source, IdentifierRef target) {
        for (IdentifierRef s : source.getIdentifiers()) {
            if (!target.getName().equals(s.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEntityTypeEditable() {
        return false;
    }

    @Override
    public boolean isDeletable() {
        return this.getModelSourceConnections().isEmpty() && this.getModelTargetConnections().size() == 1;
    }

    public RelatedRelationship findCreationRelationship() {
        AbstractConnectionModel r = this.getModelTargetConnections().get(0);
        assert (r instanceof RelatedRelationship);
        return (RelatedRelationship)r;
    }

    public CombinationTableType getCombinationTableType() {
        return this.combinationTableType;
    }

    public void setCombinationTableType(CombinationTableType combinationTableType) {
        this.combinationTableType = combinationTableType;
    }

    @Override
    public CombinationTable getCopy() {
        CombinationTable copy = new CombinationTable();
        this.copyTo(copy);
        return copy;
    }

    @Override
    public void copyTo(AbstractEntityModel to) {
        if (to instanceof CombinationTable) {
            ((CombinationTable)to).setCombinationTableType(this.getCombinationTableType());
        }
        super.copyTo(to);
    }

    @Override
    public void fireIdentifierChanged(AbstractConnectionModel callConnection) {
        this.checkDuplicateTargetReusedIdentifiers();
        super.fireIdentifierChanged(callConnection);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }
}

