/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.CombinationTable;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;

public class Resource2ResourceRelationship
extends AbstractRelationship {
    private CombinationTable table;
    private RelatedRelationship combinationTableConnection;
    private ReusedIdentifier sourceReuseIdentifier;
    private ReusedIdentifier targetReuseIdentifier;

    public Resource2ResourceRelationship(AbstractEntityModel source, AbstractEntityModel target) {
        this.setSource(source);
        this.setTarget(target);
        this.table = this.createCombinationTable(source, target);
        this.combinationTableConnection = new RelatedRelationship(this, this.table);
        this.setCenterMark(true);
    }

    private CombinationTable createCombinationTable(AbstractEntityModel source, AbstractEntityModel target) {
        CombinationTable ctable = new CombinationTable();
        ctable.setName(Resource2ResourceRelationship.createCombinationTableName(source, target));
        ImplementRule.setModelDefaultValue(ctable);
        return ctable;
    }

    private static String createCombinationTableName(AbstractEntityModel source, AbstractEntityModel target) {
        return String.valueOf(source.getName().replace(".\u5bfe\u7167\u8868", "")) + "." + target.getName().replace(".\u5bfe\u7167\u8868", "") + ".\u5bfe\u7167\u8868";
    }

    @Override
    public void connect() {
        super.connect();
        Diagram diagram = this.getSource().getDiagram();
        if (diagram != null) {
            diagram.addChild(this.table);
        }
        this.combinationTableConnection.connect();
        if (this.sourceReuseIdentifier == null) {
            this.table.addReusedIdentifier(this.getSource());
        } else {
            this.table.addReusedIdentifier(this.getSource(), this.sourceReuseIdentifier);
            this.sourceReuseIdentifier = null;
        }
        if (this.targetReuseIdentifier == null) {
            this.table.addReusedIdentifier(this.getTarget());
        } else {
            this.table.addReusedIdentifier(this.getTarget(), this.targetReuseIdentifier);
            this.targetReuseIdentifier = null;
        }
    }

    @Override
    public void disconnect() {
        this.sourceReuseIdentifier = this.table.removeReusedIdentifier(this.getSource());
        this.targetReuseIdentifier = this.table.removeReusedIdentifier(this.getTarget());
        this.combinationTableConnection.disconnect();
        Diagram diagram = this.getSource().getDiagram();
        if (diagram != null) {
            diagram.removeChild(this.table);
        }
        super.disconnect();
    }

    @Override
    public boolean isDeletable() {
        return this.table.isDeletable();
    }

    @Override
    public void identifierChanged() {
        this.table.fireIdentifierChanged(this);
    }

    @Override
    public CombinationTable getTable() {
        return this.table;
    }

    @Override
    public boolean hasTable() {
        return true;
    }
}

