/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.dialogs;

import java.beans.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.ui.dialogs.ModelEditDialog;
import org.tmdmaker.ui.dialogs.components.AttributeSettingPanel;
import org.tmdmaker.ui.dialogs.components.ImplementInfoSettingPanel;
import org.tmdmaker.ui.dialogs.components.TableNameSettingPanel;
import org.tmdmaker.ui.dialogs.model.EditTable;

public class TableEditDialog<T extends AbstractEntityModel>
extends ModelEditDialog<T> {
    private String title;
    private TableNameSettingPanel panel1;
    private AttributeSettingPanel panel2;
    private ImplementInfoSettingPanel panel3;

    public TableEditDialog(Shell parentShell, String title, AbstractEntityModel original) {
        super(parentShell);
        this.title = title;
        this.entity = new EditTable(original);
        this.entity.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Button okButton;
        if (evt.getPropertyName().equals("_edit_property_attributes")) {
            this.panel2.updateAttributeTable();
        }
        if ((okButton = this.getButton(0)) != null) {
            okButton.setEnabled(this.entity.isValid());
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new TableNameSettingPanel(composite, 0, this.entity);
        GridData gridData = new GridData(768);
        this.panel1.setLayoutData(gridData);
        gridData = new GridData(768);
        this.panel3 = new ImplementInfoSettingPanel(composite, 0, this.entity);
        this.panel3.setLayoutData(gridData);
        gridData = new GridData(768);
        this.panel2 = new AttributeSettingPanel(composite, 0, this.entity);
        this.panel2.setLayoutData(gridData);
        composite.pack();
        return composite;
    }

    protected void okPressed() {
        this.editedValue = this.entity.createEditedModel();
        super.okPressed();
    }
}

