/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.serializer.handler.patch;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.Version;
import org.tmdmaker.persistence.handler.SerializerHandler;

public abstract class AbstractSerializerHandler
implements SerializerHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractSerializerHandler() {
        this.logger.debug("Handler Start.");
    }

    public String handleBeforeDeserialize(String in) {
        this.logger.info("handleBeforeDeserialize");
        return in;
    }

    public Diagram handleAfterDeserialize(Diagram in) {
        this.logger.info("handleAfterDeserialize");
        return in;
    }

    public Diagram handleBeforeSerialize(Diagram diagram) {
        this.logger.info("handleBeforeSerialize");
        return diagram;
    }

    public String handleAfterSerialize(String in) {
        this.logger.info("handleAfterSerialize");
        return in;
    }

    protected boolean versionUnderEqual(Diagram in, int major, int minor, int serviceNo) {
        return new Version(in.getVersion()).versionUnderEqual(major, minor, serviceNo);
    }

    protected boolean versionUnderEqual(String in, int major, int minor, int serviceNo) {
        Pattern pattern = Pattern.compile("(<version>)(.*?)(</version>)", 32);
        Matcher matcher = pattern.matcher(in);
        if (matcher.find()) {
            String versionString = matcher.group(2);
            return new Version(versionString).versionUnderEqual(major, minor, serviceNo);
        }
        return false;
    }
}

