/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.imagegenerator.generator.converter;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.tmdmaker.imagegenerator.generator.converter.ImageFormatConverter;
import org.tmdmaker.imagegenerator.generator.converter.ImageFormatConverterException;

public class TiffImageFormatConverter
implements ImageFormatConverter {
    @Override
    public void convert(String file, int imageType, Image image) {
        BufferedImage bi = this.convertFromImageData(image.getImageData());
        try {
            FileOutputStream out = new FileOutputStream(file);
            ImageOutputStream io = ImageIO.createImageOutputStream(out);
            ImageIO.write((RenderedImage)bi, "TIFF", io);
        }
        catch (IOException e) {
            throw new ImageFormatConverterException(e);
        }
    }

    private BufferedImage convertFromImageData(ImageData imageData) {
        int width = imageData.width;
        int height = imageData.height;
        ImageData maskData = null;
        int[] alpha = new int[1];
        if (imageData.alphaData == null) {
            maskData = imageData.getTransparencyMask();
        }
        BufferedImage image = new BufferedImage(imageData.width, imageData.height, 2);
        WritableRaster alphaRaster = image.getAlphaRaster();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                RGB color = imageData.palette.getRGB(imageData.getPixel(x, y));
                image.setRGB(x, y, new Color(color.red, color.green, color.blue).getRGB());
                if (alphaRaster != null) {
                    if (imageData.alphaData != null) {
                        alpha[0] = imageData.getAlpha(x, y);
                        alphaRaster.setPixel(x, y, alpha);
                    } else if (maskData != null) {
                        alpha[0] = maskData.getPixel(x, y) == 0 ? 0 : 255;
                        alphaRaster.setPixel(x, y, alpha);
                    }
                }
                ++x;
            }
            ++y;
        }
        return image;
    }
}

