/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.actions.gef3;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.dialogs.DatabaseSelectDialog;

public class DatabaseSelectAction
extends Action {
    private GraphicalViewer viewer;
    public static final String ID = "DatabaseSelectAction";
    private static Logger logger = LoggerFactory.getLogger(DatabaseSelectAction.class);

    public DatabaseSelectAction(GraphicalViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.SelectDatabase);
        this.setId(ID);
    }

    public void run() {
        logger.debug("database select");
        try {
            Diagram diagram = (Diagram)this.viewer.getContents().getModel();
            DatabaseSelectDialog dialog = new DatabaseSelectDialog(this.viewer.getControl().getShell(), diagram.getDatabaseName());
            if (dialog.open() == 0) {
                this.viewer.getEditDomain().getCommandStack().execute((Command)new DatabaseChangeCommand(diagram, dialog.getSelectedDatabaseName()));
            }
        }
        catch (Throwable t) {
            logger.warn("exception when database select.", t);
        }
    }

    private static class DatabaseChangeCommand
    extends Command {
        private Diagram diagram;
        private String oldDatabaseName;
        private String newDatabaseName;

        public DatabaseChangeCommand(Diagram diagram, String newDatabaseName) {
            this.diagram = diagram;
            this.oldDatabaseName = diagram.getDatabaseName();
            this.newDatabaseName = newDatabaseName;
        }

        public void execute() {
            this.diagram.setDatabaseName(this.newDatabaseName);
        }

        public void undo() {
            this.diagram.setDatabaseName(this.oldDatabaseName);
        }
    }
}

