/*
 * ccs-queryd.c
 *
 * Manual access granter.
 *
 * Copyright (C) 2005-2006  NTT DATA CORPORATION
 *
 * Version: 1.3   2006/11/11
 *
 */
#define _FILE_OFFSET_BITS 64
#define _LARGEFILE_SOURCE
#define _LARGEFILE64_SOURCE
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <limits.h>
#include <stdlib.h>
#include <fcntl.h>
#include <termios.h>

int main(int argc, char *argv[]) {
	const int query_fd = open("/proc/ccs/policy/query", O_RDWR);
	const int domain_policy_fd = open("/proc/ccs/policy/domain_policy", O_WRONLY);
	struct termios tp, tp0;
	if (argc > 1) {
		printf("Usage: %s\n\n", argv[0]);
		printf("This program is used for granting access requests manually.\n");
		printf("This program shows access requests that are about to rejected by the kernel's decision.\n");
		printf("If you answer before the kernel's decision taken effect, your decision will take effect.\n");
		printf("You can use this program to respond to accidental access requests triggered by non-routine tasks (such as restarting daemons after updating).\n");
		printf("To terminate this program, use 'Ctrl-C'.\n");
		return 0;
	}
	if (query_fd == EOF) {
		fprintf(stderr, "You can't run this utility for this kernel.\n");
		return 1;
	} else if (write(query_fd, "", 0) != 0) {
		fprintf(stderr, "You need to register this program to /proc/ccs/policy/manager to run this program.\n");
		return 1;
	}
	write(query_fd, "\n", 1);
	tcgetattr(0, &tp0); tp = tp0;
	tp.c_lflag &= ~(ICANON | ECHO);
	tp.c_cc[VTIME] = 0;
	tp.c_cc[VMIN] = 1;
	while (1) {
		static int first = 1;
		static unsigned int prev_serial = 0;
		static char buffer[16384], prev_buffer[sizeof(buffer)] = "";
		fd_set rfds;
		unsigned int serial;
		char *cp;
		
		// Wait for query.
		FD_ZERO(&rfds);
		FD_SET(query_fd, &rfds);
		select(query_fd + 1, &rfds, NULL, NULL, NULL);
		if (!FD_ISSET(query_fd, &rfds)) continue;
		
		// Read query.
		memset(buffer, 0, sizeof(buffer));
		if (read(query_fd, buffer, sizeof(buffer) - 1) <= 0) continue;
		if ((cp = strchr(buffer, '\n')) == NULL) continue;
		*cp = '\0';
		
		// Get query number.
		if (sscanf(buffer, "Q%u", &serial) != 1) continue;
		memmove(buffer, cp + 1, strlen(cp + 1) + 1);
		
		if (!first && prev_serial == serial) {
			sleep(1);
			write(query_fd, "\n", 1);
			continue;
		}
		first = 0;
		prev_serial = serial;

		// Is this domain query?
		if (strncmp(buffer, "<kernel>", 8) == 0 && (buffer[8] == '\0' || buffer[8] == ' ') && (cp = strchr(buffer, '\n')) != NULL) {
			int c = 0;
			// Check for same domain.
			*cp = '\0';
			if (strcmp(buffer, prev_buffer)) {
				printf("----------------------------------------\n");
				printf("%s\n", buffer);
				memmove(prev_buffer, buffer, strlen(buffer) + 1);
			}
			printf("%s", cp + 1);
			printf("Accept? ('Y'es/Yes and 'A'ppend to policy/'N'o):"); fflush(stdout);
			tcsetattr(0, TCSANOW, &tp);
			while (1) {
				struct timeval tv;
				tv.tv_sec = 1; tv.tv_usec = 0;
				FD_ZERO(&rfds);
				FD_SET(0, &rfds);
				select(1, &rfds, NULL, NULL, &tv);
				if (FD_ISSET(0, &rfds)) {
					c = getc(stdin);
					if (c == EOF || c == 'Y' || c == 'y' || c == 'N' || c == 'n' || c == 'A' || c == 'a') break;
				}
				write(query_fd, "\n", 1);
			}
			tcsetattr(0, TCSANOW, &tp0);
			if (c == EOF) break;
			printf("%c\n", c);
			
			// Append to domain policy.
			if (c == 'A' || c == 'a') {
				*cp = '\n';
				write(domain_policy_fd, buffer, strlen(buffer) + 1);
				write(domain_policy_fd, "\n", 1);
			}
			
			// Write answer.
			snprintf(buffer, sizeof(buffer) - 1, "A%u=%u\n", serial, c == 'Y' || c == 'y' || c == 'A' || c == 'a' ? 1 : 2);
			write(query_fd, buffer, strlen(buffer));
		} else {
			int c;
			printf("----------------------------------------\n");
			prev_buffer[0] = '\0';
			printf("%s", buffer);
			printf("Accept? ('Y'es/'N'o):"); fflush(stdout);
			tcsetattr(0, TCSANOW, &tp);
			while (1) {
				struct timeval tv;
				tv.tv_sec = 1; tv.tv_usec = 0;
				FD_ZERO(&rfds);
				FD_SET(0, &rfds);
				select(1, &rfds, NULL, NULL, &tv);
				if (FD_ISSET(0, &rfds)) {
					c = getc(stdin);
					if (c == EOF || c == 'Y' || c == 'y' || c == 'N' || c == 'n') break;
				}
				write(query_fd, "\n", 1);
			}
			tcsetattr(0, TCSANOW, &tp0);
			if (c == EOF) break;
			printf("%c\n", c);
			
			// Write answer.
			snprintf(buffer, sizeof(buffer) - 1, "A%u=%u\n", serial, c == 'Y' || c == 'y' ? 1 : 2);
			write(query_fd, buffer, strlen(buffer));
		}
	}
	return 0;
}
