#! /bin/sh
#
# Automatic alias generator.
#
# Copyright (C) 2005-2006  NTT DATA CORPORATION
#
# Version: 1.3.1   2006/12/08
#
# Run this script and add the output to /etc/ccs/exception_policy.txt .
# You MUST review the content of /etc/ccs/exception_policy.txt
# because there would be redundant or dangerous entries.
#

for MNT in `df | awk ' { print $NF } ' | grep / | sort | uniq`
  do
  for SYMLINK in `find $MNT -xdev -type l`
	do

	# Solve symbolic name.
	ENTITY=`readlink -fn $SYMLINK`

	# Reject if it is not a regular file.
	[ -f "$ENTITY" -a -x "$ENTITY" ] || continue

	# Reject if basename is the same. 
	F1=`basename $ENTITY`
	F2=`basename $SYMLINK`
	[ $F1 = $F2 ] && continue

	# Reject if file is not executable. 
	file $ENTITY | grep -q executable || continue

	# Exclude /etc/rc?.d/ directory.
	echo $F2 | grep -q '^[SK][0-9][0-9]' && continue

	# This is a candidate.
	echo 'alias '$ENTITY' '$SYMLINK

  done
done | sort | uniq
