/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model.domain;

import java.util.ArrayList;

import org.eclipse.ui.views.properties.IPropertySource;

import jp.sourceforge.tomoyo.core.local.model.AbstractDomainPolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.except.AbstractKeepDomainElement;
import jp.sourceforge.tomoyo.core.local.model.except.ConditionalElement;
import jp.sourceforge.tomoyo.core.ui.propertysheet.domain.DomainPropertySource;

public class Domain extends AbstractDomainPolicyElement {
	
	public Domain(String name, int line, int column) {
		super(name, line, column);
	}
	
	private Profile profile;

	public Profile getProfile() {
		return profile;
	}
	
	public int getDepth() {
		return getTextFieldCount();
	}
	
	public String getDomain(int depth) {
		if (depth < 1 || depth > getDepth())
			throw new IllegalArgumentException("Specified depth " + depth + " is out of bounds.");
		StringBuffer buffer = new StringBuffer();
		for (int cnt = 0; cnt < depth; cnt++) {
			buffer.append(getText(cnt));
			if (cnt < depth - 1)
				buffer.append(" ");
		}
		return buffer.toString();
	}
	
	public String getProcessName() {
		return getText(getDepth() - 1);
	}
	
	public boolean hasChildDomain() {
		for (int cnt = 0; cnt < getChildrenCount(); cnt++) {
			if (getChild(cnt) instanceof Domain) {
				Domain domain = (Domain)getChild(cnt);
				if (!domain.isDeleted())
					return true;
			}
		}
		return false;
	}

	/**
	 * overwrides to speed up getAccessPermissionCount() and hasChildDomain() method.
	 */
	public void addChild(PolicyElement e) {
		if (e instanceof Profile) {
			this.profile = (Profile)e;
			for (int cnt = 0; cnt < getChildrenCount(); cnt++) {
				if (getChild(cnt) instanceof Profile) {
					setChild(cnt, e);
					return;
				}
			}
		}
			
		super.addChild(e);
	}

	//------------------------------------------------------------------------------------------------
	// Initialized domain related
	//------------------------------------------------------------------------------------------------
	
	private ConditionalElement initializerTarget = null;
	
	public void setInitializerTarget(ConditionalElement initializer) {
		this.initializerTarget = initializer;
	}

	public boolean isInitializerTarget() {
		return initializerTarget != null;
	}
	
	public ConditionalElement getInitializerTarget() {
		return initializerTarget;
	}
	
	//------------------------------------------------------------------------------------------------
	// Initializing domain related
	//------------------------------------------------------------------------------------------------

	private ConditionalElement initializerSource = null;
	
	public boolean isInitializerSource() {
		return initializerSource != null;
	}

	public void setInitializerSource(ConditionalElement initializer) {
		this.initializerSource = initializer;
	}

	private ArrayList<AccessPermission> initializerExecutables = new ArrayList<AccessPermission>();
	
	public void addInitializerExecutable(AccessPermission executable) {
		initializerExecutables.add(executable);
	}

	public boolean hasInitializerExecutable() {
		return initializerExecutables.size() > 0;
	}
	
	public ArrayList<AccessPermission> getInitializerExecutables() {
		return initializerExecutables;
	}

	//------------------------------------------------------------------------------------------------
	// Othres
	//------------------------------------------------------------------------------------------------

    public boolean equals(Object obj) {
		if (obj == null)
			return false;
		if (obj instanceof Domain) {
			Domain target = (Domain)obj;
			String path1 = target.getText();
			String path2 = getText();
			if (path1 == null || path2 == null)
				return false;
			return path1.equals(path2);
		}
		return false;
    }

	public boolean isKernel() {
		return getDepth() == 1;
	}

	//------------------------------------------------------------------------------------------------
	// Keep domain
	//------------------------------------------------------------------------------------------------
	
	private ArrayList<AbstractKeepDomainElement> keepDomainList = new ArrayList<AbstractKeepDomainElement>(0);
	
	public void addKeepDomain(AbstractKeepDomainElement keepDomain) {
		keepDomainList.add(keepDomain);
	}

	public boolean isKeepDomain() {
		return keepDomainList.size() > 0;
	}
	
	public void clearKeepDomain() {
		keepDomainList.clear();
	}
	
	public ArrayList<AbstractKeepDomainElement> getKeepDomainList() {
		return keepDomainList;
	}

	//------------------------------------------------------------------------------------------------
	// Reachable posibility
	//------------------------------------------------------------------------------------------------
	
	public static final int REACHABLE = 0;
	public static final int UNREACHABLE_REASON_NO_PARENTS = 1;
	public static final int UNREACHABLE_REASON_PARENT_UNREACHABLE = 2;
	public static final int UNREACHABLE_REASON_PARENT_KEPTDOMAIN = 3;
	public static final int UNREACHABLE_REASON_PARENT_INITIALIZED = 4;
	public static final int UNREACHABLE_REASON_INITIALIZED = 5;
	
	private int unreachableReason;
	
	public boolean isReachable() {
		return unreachableReason == REACHABLE;
	}

	public void setUnreachableReason(int reasonID) {
		unreachableReason = reasonID;
	}

	public int getUnreachableReason() {
		return unreachableReason;
	}

	//------------------------------------------------------------------------------------------------
	// 
	//------------------------------------------------------------------------------------------------

	protected void _initialize() {
		super._initialize();
		setSkelton(false);
		initializerExecutables.clear();
		setInitializerTarget(null);
		clearKeepDomain();
	}

	private boolean skelton = false;

	public boolean isSkelton() {
		return skelton;
	}
	
	public void setSkelton(boolean b) {
		this.skelton = b;
	}

	private boolean initialized = false;

	public void setinitialized(boolean b) {
		this.initialized = b;
	}
	
	public boolean isInitialized() {
		return initialized;
	}

	@Override
	protected IPropertySource createPropertySource() {
		return new DomainPropertySource(this);
	}

}
