/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model.domain;

import org.eclipse.ui.views.properties.IPropertySource;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import jp.sourceforge.tomoyo.core.ui.propertysheet.ElementPropertySource;

public class Profile extends PolicyElement {

	public Profile(String name, int line, int column) {
		super(name, line, column);
	}

	public String getNo() {
		return getText(1);
	}

	public boolean equals(Object obj) {
		if (!(obj instanceof Profile))
			return false;
		if (obj == null || getNo() == null)
			return false;
		return ((Profile)obj).getNo().equals(getNo());
	}

	public String getLongName() {
		Domain domain = (Domain)getParent();
		AbstractPolicyModel document = (AbstractPolicyModel)domain.getParent();
		Profile profile = domain.getProfile();
		ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(document.getProject());
		if (pp == null)
			return "";
		int groupNo = Integer.parseInt(profile.getNo());
		ProfileGroup group = pp.getGroup(groupNo);
		if (group == null)
			return "";
		return group.getLongName();
	}

	@Override
	protected IPropertySource createPropertySource() {
		return new ElementPropertySource(this);
	}
	
}
