/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.resource;

import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public abstract class LocalResource implements IRemoteResource {

	private IProject project;
	private IFile file;
	private AbstractPolicyModel model;
	
	public LocalResource(IProject project, IFile file) {
		super();
		this.project = project;
		this.file = file;
	}

	public IProject getProject() {
		return project;
	}

	public IFile getFile() {
		return file;
	}

	public void setModel(AbstractPolicyModel model) {
		this.model = model;
	}
	
	public AbstractPolicyModel getModel() {
		if (model == null) {
			model = createModel(project);
		}
		return model;
	}

	protected abstract AbstractPolicyModel createModel(IProject project);

	public void create() {
		try {
			file.create(null, true, null);
		} catch (CoreException e) {
			TomoyoCorePlugin.logException(e);
		}
	}

	public abstract String getName();

	public String getRemoteLocation() {
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
		return Utilities.concatServerPath(properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_DATA_DIRECTORY), getFile().getName());
	}

	public abstract String getSorterCommand();
	
}
