/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.ui.propertysheet.except;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.ui.propertysheet.ElementPropertySource;

public class AliasPropertySource extends ElementPropertySource {
	
	public AliasPropertySource(PolicyElement element) {
		super(element);
	}

	private static final String PROPERTY_ID_DIRECTIVE = "id.directive"; //$NON-NLS-1$
	private static final String PROPERTY_ID_SOURCE = "id.source"; //$NON-NLS-1$
	private static final String PROPERTY_ID_TARGET = "id.target"; //$NON-NLS-1$

	protected String[] getPropertyIDs() {
		return new String[] {
				PROPERTY_ID_DIRECTIVE,
				PROPERTY_ID_SOURCE,
				PROPERTY_ID_TARGET
		};
	}

	protected String getPropertyName(String propertyID) {
		if (propertyID.equals(PROPERTY_ID_DIRECTIVE))
			return Messages.Directive;
		if (propertyID.equals(PROPERTY_ID_SOURCE))
			return Messages.AliasPropertySource_Source;
		if (propertyID.equals(PROPERTY_ID_TARGET))
			return Messages.AliasPropertySource_Target;
		return null;
	}

	public Object getPropertyValue(Object id) {
		if (id == null)
			return null;
		if (id.equals(PROPERTY_ID_DIRECTIVE))
			return element.getText(0);
		if (id.equals(PROPERTY_ID_SOURCE))
			return element.getText(1);
		if (id.equals(PROPERTY_ID_TARGET))
			return element.getText(2);
		return null;
	}

}
