/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package test;

import org.eclipse.core.resources.IProject;

import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.parser.PolicyParserManager;
import junit.framework.TestCase;

public class PolicyParserManagerTest extends TestCase {

	static PolicyParserManager instance;
	
	static IProject testingProject;

	public void testGetInstance() {
		PolicyParserManager instance1 = PolicyParserManager.getInstance();
		assertTrue(instance1 instanceof PolicyParserManager);
		PolicyParserManager instance2 = PolicyParserManager.getInstance();
		assertEquals(instance1, instance2);
		
		instance = instance1;
		testingProject = TomoyoCorePluginTest.getTestingProject();
	}

	public void testUpdate() {
	}

	public void testPreload() {
	//	assertEquals(0, DomainCacheManager.getInstance().listDomains(testingProject).size());
		
		PolicyParserManager.getInstance().preload(testingProject);
		
		assertTrue(PolicyCacheManager.getInstance().countDomains(testingProject, false) > 0);
	}

}
