/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class CoreEditorFormToolkit extends FormToolkit {

	public CoreEditorFormToolkit(Display display) {
		super(display);
	}

	private FormColors colors = new FormColors(Activator.getStandardDisplay());

	public Section createSection(Composite parent, int sectionStyle) {
		CoreEditorSection section = new CoreEditorSection(parent,sectionStyle);
		section.setMenu(parent.getMenu());
		adapt(section, true, true);
/*		
		if (section.toggle != null) {
			section.toggle.setHoverDecorationColor(colors
					.getColor(FormColors.TB_TOGGLE_HOVER));
			section.toggle.setDecorationColor(colors
					.getColor(FormColors.TB_TOGGLE));
		}
*/		
//		section.setFont(boldFontHolder.getBoldFont(parent.getFont()));
		
		if ((sectionStyle & Section.TITLE_BAR) != 0
				|| (sectionStyle & Section.SHORT_TITLE_BAR) != 0) {
			colors.initializeSectionToolBarColors();
			section.setTitleBarBackground(colors.getColor(FormColors.TB_GBG));
			section.setTitleBarBorderColor(colors
					.getColor(FormColors.TB_BORDER));
			section.setTitleBarGradientBackground(colors
					.getColor(FormColors.TB_GBG));
			section.setTitleBarForeground(colors.getColor(FormColors.TB_FG));
		}
		return section;

	}

	public ScrolledForm createScrolledForm(Composite parent) {
		ScrolledForm form = new ScrolledForm(parent, SWT.V_SCROLL | SWT.H_SCROLL | getOrientation());
		form.setExpandHorizontal(true);
		form.setExpandVertical(true);
		form.setBackground(colors.getBackground());
		form.setForeground(colors.getColor(FormColors.TITLE));
		colors.initializeSectionToolBarColors();
		form.getForm().setSeparatorColor(colors.getColor(FormColors.TB_BORDER));
//		form.setFont(JFaceResources.getHeaderFont());
		return form;
	}

}
